/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTimestampsCache {
    public static final String REGION_NAME = UpdateTimestampsCache.class.getName();
    private static final Logger log = LoggerFactory.getLogger(UpdateTimestampsCache.class);
    private final TimestampsRegion region;

    public UpdateTimestampsCache(Settings settings, Properties props) throws HibernateException {
        String prefix = settings.getCacheRegionPrefix();
        String regionName = prefix == null ? REGION_NAME : prefix + '.' + REGION_NAME;
        log.info("starting update timestamps cache at region: " + regionName);
        this.region = settings.getRegionFactory().buildTimestampsRegion(regionName, props);
    }

    public synchronized void preinvalidate(Serializable[] spaces) throws CacheException {
        Long ts = new Long(this.region.nextTimestamp() + (long)this.region.getTimeout());
        for (int i = 0; i < spaces.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug("Pre-invalidating space [" + spaces[i] + "]");
            }
            this.region.put(spaces[i], ts);
        }
    }

    public synchronized void invalidate(Serializable[] spaces) throws CacheException {
        Long ts = new Long(this.region.nextTimestamp());
        for (int i = 0; i < spaces.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug("Invalidating space [" + spaces[i] + "], timestamp: " + ts);
            }
            this.region.put(spaces[i], ts);
        }
    }

    public synchronized boolean isUpToDate(Set spaces, Long timestamp) throws HibernateException {
        for (Serializable space : spaces) {
            Long lastUpdate = (Long)this.region.get(space);
            if (lastUpdate == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("[" + space + "] last update timestamp: " + lastUpdate + ", result set timestamp: " + timestamp);
            }
            if (lastUpdate < timestamp) continue;
            return false;
        }
        return true;
    }

    public void clear() throws CacheException {
        this.region.evictAll();
    }

    public void destroy() {
        try {
            this.region.destroy();
        }
        catch (Exception e) {
            log.warn("could not destroy UpdateTimestamps cache", (Throwable)e);
        }
    }

    public TimestampsRegion getRegion() {
        return this.region;
    }

    public String toString() {
        return "UpdateTimestampeCache";
    }
}

