/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.ClobProxy;
import org.hibernate.engine.jdbc.WrappedClob;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.IncomparableComparator;
import org.hibernate.type.descriptor.java.MutabilityPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClobTypeDescriptor
extends AbstractTypeDescriptor<Clob> {
    public static final ClobTypeDescriptor INSTANCE = new ClobTypeDescriptor();

    public ClobTypeDescriptor() {
        super(Clob.class, ClobMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(Clob value) {
        try {
            return DataHelper.extractString(value.getCharacterStream());
        }
        catch (SQLException e) {
            throw new HibernateException("Unable to access clob stream", e);
        }
    }

    @Override
    public Clob fromString(String string) {
        return ClobProxy.generateProxy(string);
    }

    @Override
    public Comparator<Clob> getComparator() {
        return IncomparableComparator.INSTANCE;
    }

    @Override
    public int extractHashCode(Clob value) {
        return System.identityHashCode(value);
    }

    @Override
    public boolean areEqual(Clob one, Clob another) {
        return one == another;
    }

    @Override
    public <X> X unwrap(Clob value, Class<X> type, WrapperOptions options) {
        if (!Clob.class.isAssignableFrom(type)) {
            throw this.unknownUnwrap(type);
        }
        if (value == null) {
            return null;
        }
        Clob clob = WrappedClob.class.isInstance(value) ? ((WrappedClob)((Object)value)).getWrappedClob() : value;
        return (X)clob;
    }

    @Override
    public <X> Clob wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (!Clob.class.isAssignableFrom(value.getClass())) {
            throw this.unknownWrap(value.getClass());
        }
        return options.getLobCreator().wrap((Clob)value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClobMutabilityPlan
    implements MutabilityPlan<Clob> {
        public static final ClobMutabilityPlan INSTANCE = new ClobMutabilityPlan();

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public Clob deepCopy(Clob value) {
            return value;
        }

        @Override
        public Serializable disassemble(Clob value) {
            throw new UnsupportedOperationException("Clobs are not cacheable");
        }

        @Override
        public Clob assemble(Serializable cached) {
            throw new UnsupportedOperationException("Clobs are not cacheable");
        }
    }
}

