/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.schema.validator;

import org.opensaml.xml.schema.XSBase64Binary;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSBase64BinarySchemaValidator<T extends XSBase64Binary>
implements Validator<T> {
    private boolean allowEmptyContent;

    public XSBase64BinarySchemaValidator(boolean allowEmptyElementContent) {
        this.allowEmptyContent = allowEmptyElementContent;
    }

    public XSBase64BinarySchemaValidator() {
        this.allowEmptyContent = false;
    }

    @Override
    public void validate(T xmlObject) throws ValidationException {
        this.validateBase64BinaryContent(xmlObject);
    }

    protected boolean isAllowEmptyContent() {
        return this.allowEmptyContent;
    }

    protected void validateBase64BinaryContent(T xmlObject) throws ValidationException {
        if (!this.isAllowEmptyContent() && DatatypeHelper.isEmpty(xmlObject.getValue())) {
            throw new ValidationException("Base64Binary content may not be empty");
        }
    }
}

