/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.stream.impl;

import de.odysseus.staxon.json.stream.JsonStreamFactory;
import de.odysseus.staxon.json.stream.JsonStreamSource;
import de.odysseus.staxon.json.stream.JsonStreamTarget;
import de.odysseus.staxon.json.stream.impl.JsonStreamSourceImpl;
import de.odysseus.staxon.json.stream.impl.JsonStreamTargetImpl;
import de.odysseus.staxon.json.stream.impl.Yylex;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class JsonStreamFactoryImpl
extends JsonStreamFactory {
    private final String prettyIndent;
    private final String prettyNewline;
    private final String prettySpace;

    public JsonStreamFactoryImpl() {
        this(" ", "\t", "\n");
    }

    public JsonStreamFactoryImpl(String prettySpace, String prettyIndent, String prettyNewline) {
        this.prettySpace = prettySpace;
        this.prettyIndent = prettyIndent;
        this.prettyNewline = prettyNewline;
    }

    @Override
    public JsonStreamSource createJsonStreamSource(InputStream input) throws IOException {
        return this.createJsonStreamSource(new InputStreamReader(input, "UTF-8"));
    }

    @Override
    public JsonStreamSource createJsonStreamSource(Reader reader) {
        return new JsonStreamSourceImpl(new Yylex(reader), false);
    }

    @Override
    public JsonStreamTarget createJsonStreamTarget(OutputStream output, boolean pretty) throws IOException {
        return this.createJsonStreamTarget(new OutputStreamWriter(output, "UTF-8"), pretty);
    }

    @Override
    public JsonStreamTarget createJsonStreamTarget(Writer writer, boolean pretty) {
        if (pretty) {
            return new JsonStreamTargetImpl(writer, false, this.prettySpace, this.prettyIndent, this.prettyNewline);
        }
        return new JsonStreamTargetImpl(writer, false);
    }
}

