/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.util;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventConsumer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMEventConsumer
implements XMLEventConsumer {
    private final Document document;
    private final boolean namespaceAware;
    private Node node;

    public DOMEventConsumer(Node node) {
        this(node, true);
    }

    public DOMEventConsumer(Node node, boolean namespaceAware) {
        this.document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        this.namespaceAware = namespaceAware;
        this.node = node;
    }

    private String qName(QName name) {
        if ("".equals(name.getPrefix())) {
            return name.getLocalPart();
        }
        return name.getPrefix() + ':' + name.getLocalPart();
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        switch (event.getEventType()) {
            case 12: {
                this.node.appendChild(this.document.createCDATASection(event.asCharacters().getData()));
                break;
            }
            case 4: {
                this.node.appendChild(this.document.createTextNode(event.asCharacters().getData()));
                break;
            }
            case 5: {
                this.node.appendChild(this.document.createComment(((Comment)event).getText()));
                break;
            }
            case 2: {
                this.node = this.node.getParentNode();
                break;
            }
            case 9: {
                this.node.appendChild(this.document.createEntityReference(((EntityReference)event).getName()));
                break;
            }
            case 3: {
                ProcessingInstruction pi = (ProcessingInstruction)event;
                this.node.appendChild(this.document.createProcessingInstruction(pi.getTarget(), pi.getData()));
                break;
            }
            case 1: {
                StartElement startElement = event.asStartElement();
                QName elementName = startElement.getName();
                Element element = this.namespaceAware ? this.document.createElementNS(elementName.getNamespaceURI(), this.qName(elementName)) : this.document.createElement(elementName.getLocalPart());
                Iterator<Namespace> namespaces = startElement.getNamespaces();
                while (namespaces.hasNext()) {
                    Namespace ns = namespaces.next();
                    element.setAttributeNS(ns.getName().getNamespaceURI(), this.qName(ns.getName()), ns.getNamespaceURI());
                }
                Iterator<Attribute> attributes = startElement.getAttributes();
                while (attributes.hasNext()) {
                    Attribute at = attributes.next();
                    if (this.namespaceAware) {
                        element.setAttributeNS(at.getName().getNamespaceURI(), this.qName(at.getName()), at.getValue());
                        continue;
                    }
                    element.setAttribute(at.getName().getLocalPart(), at.getValue());
                }
                this.node = this.node.appendChild(element);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                throw new XMLStreamException("Unexpected event type " + event.getEventType() + "; " + event);
            }
        }
    }

    public void add(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            this.add(reader.nextEvent());
        }
    }

    public static Document consume(XMLEventReader reader) throws XMLStreamException {
        DocumentBuilder documentBuilder;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XMLStreamException(e);
        }
        return DOMEventConsumer.consume(reader, documentBuilder);
    }

    public static Document consume(XMLEventReader reader, DocumentBuilder documentBuilder) throws XMLStreamException {
        Document document = documentBuilder.newDocument();
        DOMEventConsumer.consume(reader, document);
        return document;
    }

    public static void consume(XMLEventReader reader, Node node) throws XMLStreamException {
        boolean namespaceAware = true;
        new DOMEventConsumer(node, namespaceAware).add(reader);
    }
}

