/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util.sftp;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.sftp.SftpSubsystem;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SftpServer {
    public static final String USERNAME = "muletest1";
    public static final String PASSWORD = "muletest1";
    private SshServer sshdServer;
    private Integer port;

    public SftpServer(int port) {
        this.port = port;
        this.configureSecurityProvider();
        SftpSubsystem.Factory factory = this.createFtpSubsystemFactory();
        this.sshdServer = SshServer.setUpDefaultServer();
        this.configureSshdServer(factory, SftpServer.passwordAuthenticator());
    }

    private void configureSshdServer(SftpSubsystem.Factory factory, PasswordAuthenticator passwordAuthenticator) {
        this.sshdServer.setPort(this.port.intValue());
        this.sshdServer.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider("hostkey.ser"));
        this.sshdServer.setSubsystemFactories(Arrays.asList(factory));
        this.sshdServer.setCommandFactory((CommandFactory)new ScpCommandFactory());
        this.sshdServer.setShellFactory((Factory)new ProcessShellFactory());
        this.sshdServer.setPasswordAuthenticator(passwordAuthenticator);
    }

    private SftpSubsystem.Factory createFtpSubsystemFactory() {
        SftpSubsystem.Factory factory = new SftpSubsystem.Factory();
        return factory;
    }

    private void configureSecurityProvider() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private static PasswordAuthenticator passwordAuthenticator() {
        return new PasswordAuthenticator(){

            public boolean authenticate(String arg0, String arg1, ServerSession arg2) {
                return "muletest1".equals(arg0) && "muletest1".equals(arg1);
            }
        };
    }

    public void start() {
        try {
            this.sshdServer.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.sshdServer.stop();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.sshdServer = null;
    }
}

