/*
 * $Id$
 *  --------------------------------------------------------------------------------------
 *  Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 *  The software in this package is published under the terms of the CPAL v1.0
 *  license, a copy of which has been included with this distribution in the
 *  LICENSE.txt file.
 */

package org.mule.config.pool;

import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsInstanceOf.instanceOf;
import static org.hamcrest.core.IsNull.notNullValue;
import static org.junit.Assert.assertThat;

import org.mule.api.config.ThreadingProfile;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.junit.Test;

public class DefaultThreadPoolFactoryTestCase extends AbstractMuleContextTestCase
{

    @Test
    public void defaultThreadPoolFactory() throws Exception
    {
        final ThreadingProfile tp = muleContext.getDefaultThreadingProfile();
        final ThreadPoolFactory pf = tp.getPoolFactory();
        assertThat(pf, instanceOf(DefaultThreadPoolFactory.class));
    }

    @Test
    public void scheduledThreadPollDefaults() throws Exception
    {
        ThreadingProfile threadingProfile = muleContext.getDefaultThreadingProfile();
        ScheduledExecutorService executorService = threadingProfile.createScheduledPool("sapo pepe");
        assertThat(executorService, notNullValue());
        assertThat(executorService, instanceOf(ScheduledThreadPoolExecutor.class));
        ScheduledThreadPoolExecutor scheduledPool = (ScheduledThreadPoolExecutor) executorService;
        assertThat(scheduledPool.getContinueExistingPeriodicTasksAfterShutdownPolicy(), is(false));
        assertThat(scheduledPool.getExecuteExistingDelayedTasksAfterShutdownPolicy(), is(true));
        assertThat(scheduledPool.getMaximumPoolSize(), is(threadingProfile.getMaxThreadsActive()));
        assertThat(scheduledPool.getCorePoolSize(), is(threadingProfile.getMaxThreadsIdle()));
        assertThat(scheduledPool.getKeepAliveTime(TimeUnit.MILLISECONDS),is(threadingProfile.getThreadTTL()));
    }
}
