/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.fluent.util;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.RouterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ScopeDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.util.DeclarationWalker;
import org.mule.runtime.api.util.Reference;

public class IdempotentDeclarationWalker
extends DeclarationWalker {
    private Set<Reference<SourceDeclaration>> sources = new LinkedHashSet<Reference<SourceDeclaration>>();
    private Set<Reference<ParameterDeclaration>> parameters = new LinkedHashSet<Reference<ParameterDeclaration>>();
    private Set<Reference<ParameterGroupDeclaration>> parameterGroups = new LinkedHashSet<Reference<ParameterGroupDeclaration>>();
    private Set<Reference<OperationDeclaration>> operations = new LinkedHashSet<Reference<OperationDeclaration>>();
    private Set<Reference<ConnectionProviderDeclaration>> connectionProviders = new LinkedHashSet<Reference<ConnectionProviderDeclaration>>();

    private <T> boolean isFirstAppearance(Set<Reference<T>> accumulator, T item) {
        return accumulator.add(new Reference(item));
    }

    protected void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
        this.doOnce(this.sources, declaration, this::onSource);
    }

    protected void onParameterGroup(ParameterizedDeclaration owner, ParameterGroupDeclaration declaration) {
        this.doOnce(this.parameterGroups, declaration, this::onParameterGroup);
    }

    protected void onParameter(ParameterizedDeclaration owner, ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
        this.doOnce(this.parameters, declaration, p -> this.onParameter(parameterGroup, declaration));
    }

    protected void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
        this.doOnce(this.operations, declaration, this::onOperation);
    }

    protected void onRouter(WithOperationsDeclaration owner, RouterDeclaration declaration) {
        this.doOnce(this.operations, declaration, router -> this.onRouter((RouterDeclaration)router));
    }

    protected void onScope(WithOperationsDeclaration owner, ScopeDeclaration declaration) {
        this.doOnce(this.operations, declaration, scope -> this.onScope((ScopeDeclaration)scope));
    }

    protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
        this.doOnce(this.connectionProviders, declaration, this::onConnectionProvider);
    }

    private <T> void doOnce(Set<Reference<T>> accumulator, T item, Consumer<T> delegate) {
        if (this.isFirstAppearance(accumulator, item)) {
            delegate.accept(item);
        }
    }

    protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
    }

    protected void onSource(SourceDeclaration declaration) {
    }

    protected void onParameterGroup(ParameterGroupDeclaration declaration) {
    }

    protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
    }

    protected void onOperation(OperationDeclaration declaration) {
    }

    protected void onScope(ScopeDeclaration declaration) {
        this.onOperation((OperationDeclaration)declaration);
    }

    protected void onRouter(RouterDeclaration declaration) {
        this.onOperation((OperationDeclaration)declaration);
    }
}

