/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.Configuration;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import org.w3c.dom.TypeInfo;

public class TypeInfoImpl
implements TypeInfo {
    private Configuration config;
    private SchemaType schemaType;

    public TypeInfoImpl(Configuration config, SchemaType type) {
        this.config = config;
        this.schemaType = type;
    }

    public String getTypeName() {
        return this.schemaType.getStructuredQName().getLocalPart();
    }

    public String getTypeNamespace() {
        return this.schemaType.getStructuredQName().getURI();
    }

    public boolean isDerivedFrom(String typeNamespaceArg, String typeNameArg, int derivationMethod) throws IllegalStateException {
        SchemaType base = this.schemaType.getBaseType();
        int fingerprint = this.config.getNamePool().allocate("", typeNamespaceArg, typeNameArg);
        if (derivationMethod == 0 || (derivationMethod & this.schemaType.getDerivationMethod()) != 0) {
            if (base.getFingerprint() == fingerprint) {
                return true;
            }
            if (base instanceof AnyType) {
                return false;
            }
            return new TypeInfoImpl(this.config, base).isDerivedFrom(typeNamespaceArg, typeNameArg, derivationMethod);
        }
        return false;
    }
}

