/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.evpull.EmptyEventIterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentInvocation;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.UserFunctionResolvable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class UserFunctionCall
extends FunctionCall
implements UserFunctionResolvable,
ComponentInvocation,
ContextOriginator {
    private SequenceType staticType;
    private UserFunction function;
    private int bindingSlot = -1;
    private int tailCall = 0;
    private StructuredQName name;
    private int[] argumentEvaluationModes = null;
    public static final int NOT_TAIL_CALL = 0;
    public static final int FOREIGN_TAIL_CALL = 1;
    public static final int SELF_TAIL_CALL = 2;

    public final void setFunctionName(StructuredQName name) {
        this.name = name;
    }

    public void setStaticType(SequenceType type) {
        this.staticType = type;
    }

    public void setFunction(UserFunction compiledFunction) {
        this.function = compiledFunction;
    }

    public void setBindingSlot(int slot) {
        this.bindingSlot = slot;
    }

    public int getBindingSlot() {
        return this.bindingSlot;
    }

    public UserFunction getFunction() {
        return this.function;
    }

    public Component getFixedTarget() {
        Visibility v = this.function.getDeclaringComponent().getVisibility();
        if (v == Visibility.PRIVATE || v == Visibility.FINAL) {
            return this.function.getDeclaringComponent();
        }
        return null;
    }

    public boolean isTailCall() {
        return this.tailCall != 0;
    }

    public boolean isRecursiveTailCall() {
        return this.tailCall == 2;
    }

    public final StructuredQName getFunctionName() {
        if (this.name == null) {
            return this.function.getFunctionName();
        }
        return this.name;
    }

    public SymbolicName getSymbolicName() {
        return new SymbolicName(158, this.getFunctionName(), this.getArity());
    }

    public Component getTarget() {
        return this.function.getDeclaringComponent();
    }

    public int[] getArgumentEvaluationModes() {
        return this.argumentEvaluationModes;
    }

    public void setArgumentEvaluationModes(int[] evalModes) {
        this.argumentEvaluationModes = evalModes;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public ItemType getItemType() {
        if (this.staticType == null) {
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    public int getIntrinsicDependencies() {
        return 256;
    }

    public boolean isUpdatingExpression() {
        return this.function.isUpdating();
    }

    protected int computeSpecialProperties() {
        if (this.function == null || this.function.getBody() == null) {
            return super.computeSpecialProperties();
        }
        ArrayList<UserFunction> calledFunctions = new ArrayList<UserFunction>();
        ExpressionTool.gatherCalledFunctions(this.function.getBody(), calledFunctions);
        int props = calledFunctions.isEmpty() ? this.function.getBody().computeSpecialProperties() : super.computeSpecialProperties();
        if (this.function.getDeterminism() != UserFunction.Determinism.PROACTIVE) {
            props |= 0x400000;
        }
        return props;
    }

    public Expression copy(RebindingMap rebindings) {
        if (this.function == null) {
            throw new UnsupportedOperationException("UserFunctionCall.copy()");
        }
        UserFunctionCall ufc = new UserFunctionCall();
        ufc.setFunction(this.function);
        ufc.setStaticType(this.staticType);
        int numArgs = this.getArity();
        Expression[] a2 = new Expression[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            a2[i] = this.getArg(i).copy(rebindings);
        }
        ufc.setArguments(a2);
        ExpressionTool.copyLocationInfo(this, ufc);
        return ufc;
    }

    public int computeCardinality() {
        if (this.staticType == null) {
            return 57344;
        }
        return this.staticType.getCardinality();
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e = super.typeCheck(visitor, contextInfo);
        if (e != this) {
            return e;
        }
        if (this.function != null) {
            this.checkFunctionCall(this.function, visitor);
            if (this.function.getFunctionName() == null) {
                throw new IllegalStateException();
            }
            if (this.staticType == SequenceType.ANY_SEQUENCE) {
                this.staticType = this.function.getResultType();
            }
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this && this.function != null) {
            Expression e2 = this.getConfiguration().obtainOptimizer().tryInlineFunctionCall(this, visitor, contextItemType);
            if (e2 != this) {
                return e2.optimize(visitor, contextItemType);
            }
            return e2;
        }
        return e;
    }

    public synchronized void computeArgumentEvaluationModes() {
        int numArgs = this.getArity();
        int[] argModes = new int[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            Expression arg;
            argModes[i] = this.function.getParameterDefinitions()[i].isIndexedVariable() ? 12 : (((arg = this.getArg(i)).getDependencies() & 0x100) != 0 ? ExpressionTool.eagerEvaluationMode(arg) : (!Cardinality.allowsMany(arg.getCardinality()) && arg.getCost() < 20 ? ExpressionTool.eagerEvaluationMode(arg) : (arg instanceof Block && ((Block)arg).isCandidateForSharedAppend() ? 11 : 4)));
        }
        this.argumentEvaluationModes = argModes;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addExternalFunctionCallToPathMap(pathMap, pathMapNodeSet);
    }

    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        this.tailCall = this.getFunctionName().equals(qName) && arity == this.getArity() ? 2 : 1;
        return this.tailCall;
    }

    public int getImplementationMethod() {
        if (Cardinality.allowsMany(this.getCardinality())) {
            return 6;
        }
        return 1;
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        return this.callFunction(c).head();
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        return this.callFunction(c).iterate();
    }

    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        Sequence[] actualArgs = this.evaluateArguments(context);
        XPathContextMajor c2 = context.newCleanContext();
        c2.setOrigin(this);
        this.function.callUpdating(actualArgs, c2, pul);
    }

    private Sequence callFunction(XPathContext context) throws XPathException {
        XPathContextMajor c2;
        UserFunction targetFunction;
        Sequence[] actualArgs = this.evaluateArguments(context);
        if (this.isTailCall()) {
            this.requestTailCall(context, actualArgs);
            return EmptySequence.getInstance();
        }
        if (this.bindingSlot >= 0) {
            Component target = this.getTargetComponent(context);
            targetFunction = (UserFunction)target.getCode();
            Component targetComponent = target;
            if (targetComponent.getVisibility() == Visibility.ABSENT) {
                throw new XPathException("Cannot call a function defined with visibility=absent", "XTDE3052");
            }
            c2 = targetFunction.makeNewContext(context);
            c2.setCurrentComponent(targetComponent);
        } else {
            targetFunction = this.function;
            c2 = targetFunction.makeNewContext(context);
        }
        try {
            return targetFunction.call(c2, actualArgs);
        }
        catch (StackOverflowError err) {
            throw new XPathException("Too many nested function calls. May be due to infinite recursion", "SXLM0001", this.getLocation());
        }
    }

    private void requestTailCall(XPathContext context, Sequence[] actualArgs) throws XPathException {
        if (this.bindingSlot >= 0) {
            Component target;
            TailCallLoop.TailCallComponent info = new TailCallLoop.TailCallComponent();
            info.component = target = this.getTargetComponent(context);
            info.function = (UserFunction)target.getCode();
            ((XPathContextMajor)context).requestTailCall(info, actualArgs);
        } else {
            TailCallLoop.TailCallFunction info = new TailCallLoop.TailCallFunction();
            info.function = this.function;
            ((XPathContextMajor)context).requestTailCall(info, actualArgs);
        }
    }

    public void process(XPathContext context) throws XPathException {
        Sequence[] actualArgs = this.evaluateArguments(context);
        if (this.isTailCall()) {
            this.requestTailCall(context, actualArgs);
            return;
        }
        if (this.bindingSlot >= 0) {
            Component target = this.getTargetComponent(context);
            UserFunction targetFunction = (UserFunction)target.getCode();
            if (target.getVisibility() == Visibility.ABSENT) {
                throw new XPathException("Cannot call a function defined with visibility=absent", "XTDE3052");
            }
            XPathContextMajor c2 = targetFunction.makeNewContext(context);
            c2.setCurrentComponent(target);
            targetFunction.process(actualArgs, c2);
        } else {
            XPathContextMajor c2 = this.function.makeNewContext(context);
            this.function.process(actualArgs, c2);
        }
    }

    private Component getTargetComponent(XPathContext context) {
        if (this.bindingSlot == -1) {
            return this.function.getDeclaringComponent();
        }
        return context.getTargetComponent(this.bindingSlot);
    }

    public UserFunction getTargetFunction(XPathContext context) {
        return (UserFunction)this.getTargetComponent(context).getCode();
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        Sequence[] actualArgs = this.evaluateArguments(context);
        if (this.isTailCall()) {
            this.requestTailCall(context, actualArgs);
            return EmptyEventIterator.getInstance();
        }
        Component target = this.getTargetComponent(context);
        UserFunction targetFunction = (UserFunction)target.getCode();
        Component targetComponent = target;
        if (targetComponent.getVisibility() == Visibility.ABSENT) {
            throw new XPathException("Cannot call a function defined with visibility=absent", "XTDE3052");
        }
        XPathContextMajor c2 = targetFunction.makeNewContext(context);
        c2.setCurrentComponent(targetComponent);
        return targetFunction.iterateEvents(actualArgs, c2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence[] evaluateArguments(XPathContext c) throws XPathException {
        int numArgs = this.getArity();
        Sequence[] actualArgs = new Sequence[numArgs];
        UserFunctionCall userFunctionCall = this;
        synchronized (userFunctionCall) {
            if (this.argumentEvaluationModes == null) {
                this.computeArgumentEvaluationModes();
            }
        }
        for (int i = 0; i < numArgs; ++i) {
            int refs = 10;
            actualArgs[i] = ExpressionTool.evaluate(this.getArg(i), this.argumentEvaluationModes[i], c, refs);
            if (actualArgs[i] != null) continue;
            actualArgs[i] = EmptySequence.getInstance();
        }
        return actualArgs;
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("ufCall", this);
        if (this.getFunctionName() != null) {
            out.emitAttribute("name", this.getFunctionName().getEQName());
            out.emitAttribute("tailCall", this.tailCall == 0 ? "false" : (this.tailCall == 2 ? "self" : "foreign"));
        }
        out.emitAttribute("bSlot", "" + this.getBindingSlot());
        if (this.getArgumentEvaluationModes() != null && this.getArity() > 0) {
            int[] e;
            FastStringBuffer fsb = new FastStringBuffer(64);
            for (int i : e = this.getArgumentEvaluationModes()) {
                fsb.append(i + " ");
            }
            out.emitAttribute("eval", Whitespace.trim(fsb));
        }
        for (Operand o : this.operands()) {
            o.getChildExpression().export(out);
        }
        if (this.getFunctionName() == null) {
            out.setChildRole("inline");
            this.function.getBody().export(out);
            out.endElement();
        }
        out.endElement();
    }

    public int getConstructType() {
        return 2009;
    }

    public Object getProperty(String name) {
        if (name.equals("target")) {
            return this.function;
        }
        return super.getProperty(name);
    }

    public StructuredQName getObjectName() {
        return this.getFunctionName();
    }
}

