/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.util.regex.Pattern;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class TEXTEmitter
extends XMLEmitter {
    private Pattern newlineMatcher = null;
    private String newlineRepresentation = null;

    public void open() throws XPathException {
    }

    protected void openDocument() throws XPathException {
        String encoding;
        if (this.writer == null) {
            this.makeWriter();
        }
        if (this.characterSet == null) {
            this.characterSet = UTF8CharacterSet.getInstance();
        }
        if ((encoding = this.outputProperties.getProperty("encoding")) == null || encoding.equalsIgnoreCase("utf8")) {
            encoding = "UTF-8";
        }
        String byteOrderMark = this.outputProperties.getProperty("byte-order-mark");
        String nl = this.outputProperties.getProperty("{http://saxon.sf.net/}newline");
        if (nl != null && !nl.equals("\n")) {
            this.newlineRepresentation = nl;
            this.newlineMatcher = Pattern.compile("\\n");
        }
        if ("yes".equals(byteOrderMark) && ("UTF-8".equalsIgnoreCase(encoding) || "UTF-16LE".equalsIgnoreCase(encoding) || "UTF-16BE".equalsIgnoreCase(encoding))) {
            try {
                this.writer.write(65279);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.started = true;
    }

    public void writeDeclaration() throws XPathException {
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        int badchar;
        if (!this.started) {
            this.openDocument();
        }
        if ((properties & 4) == 0 && (badchar = this.testCharacters(chars)) != 0) {
            throw new XPathException("Output character not available in this encoding (x" + Integer.toString(badchar, 16) + ")", "SERE0008");
        }
        if (this.newlineMatcher != null) {
            chars = this.newlineMatcher.matcher(chars).replaceAll(this.newlineRepresentation);
        }
        try {
            this.writer.write(chars.toString());
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) {
        this.previousAtomic = false;
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) {
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) {
    }

    public void endElement() {
    }

    public void processingInstruction(String name, CharSequence value, Location locationId, int properties) throws XPathException {
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
    }
}

