/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLFunction
extends StyleElement
implements StylesheetComponent {
    private boolean doneAttributes = false;
    private String nameAtt = null;
    private String asAtt = null;
    private SequenceType resultType;
    private SlotManager stackFrameMap;
    private boolean memoFunction = false;
    private String overrideExtensionFunctionAtt = null;
    private boolean overrideExtensionFunction = true;
    private int numberOfArguments = -1;
    private UserFunction compiledFunction;
    private Visibility visibility;
    private FunctionStreamability streamability;
    private UserFunction.Determinism determinism = UserFunction.Determinism.PROACTIVE;

    public UserFunction getCompiledProcedure() {
        return this.compiledFunction;
    }

    public boolean isDeclaration() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        if (this.doneAttributes) {
            return;
        }
        this.doneAttributes = true;
        AttributeCollection atts = this.getAttributeList();
        this.overrideExtensionFunctionAtt = null;
        String visibilityAtt = null;
        String cacheAtt = null;
        String newEachTimeAtt = null;
        String streamabilityAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String uri = atts.getURI(a);
            String local = atts.getLocalName(a);
            if ("".equals(uri)) {
                if (local.equals("name")) {
                    this.nameAtt = Whitespace.trim(atts.getValue(a));
                    assert (this.nameAtt != null);
                    if (this.nameAtt.indexOf(58) < 0) {
                        this.nameAtt = "Q{http://saxon.sf.net/}error-function-name";
                        this.compileError("Function name must have a namespace prefix", "XTSE0740");
                    }
                    try {
                        this.setObjectName(this.makeQName(this.nameAtt));
                    }
                    catch (NamespaceException err) {
                        this.compileError(err.getMessage(), "XTSE0280");
                    }
                    catch (XPathException err) {
                        this.compileError(err);
                    }
                    continue;
                }
                if (local.equals("as")) {
                    this.asAtt = atts.getValue(a);
                    continue;
                }
                if (local.equals("visibility")) {
                    visibilityAtt = Whitespace.trim(atts.getValue(a));
                    continue;
                }
                if (local.equals("streamability")) {
                    streamabilityAtt = Whitespace.trim(atts.getValue(a));
                    continue;
                }
                if (local.equals("override")) {
                    String overrideAtt = Whitespace.trim(atts.getValue(a));
                    boolean override = this.processBooleanAttribute("override", overrideAtt);
                    if (this.overrideExtensionFunctionAtt != null) {
                        if (override != this.overrideExtensionFunction) {
                            this.compileError("Attributes override-extension-function and override are both used, but do not match", "XTSE0020");
                        }
                    } else {
                        this.overrideExtensionFunctionAtt = overrideAtt;
                        this.overrideExtensionFunction = override;
                    }
                    if (!this.isXslt30Processor()) continue;
                    this.compileWarning("The xsl:function/@override attribute is deprecated; use override-extension-function", "SXWN9014");
                    continue;
                }
                if (local.equals("override-extension-function") && this.isXslt30Processor()) {
                    String overrideExtAtt = Whitespace.trim(atts.getValue(a));
                    boolean overrideExt = this.processBooleanAttribute("override-extension-function", overrideExtAtt);
                    if (this.overrideExtensionFunctionAtt != null) {
                        if (overrideExt != this.overrideExtensionFunction) {
                            this.compileError("Attributes override-extension-function and override are both used, but do not match", "XTSE0020");
                        }
                    } else {
                        this.overrideExtensionFunctionAtt = overrideExtAtt;
                        this.overrideExtensionFunction = overrideExt;
                    }
                    if (!local.equals("override")) continue;
                    this.compileWarning("The xsl:function/@override attribute is deprecated; use override-extension-function", "SXWN9014");
                    continue;
                }
                if (local.equals("cache")) {
                    cacheAtt = Whitespace.trim(atts.getValue(a));
                    continue;
                }
                if (local.equals("new-each-time")) {
                    newEachTimeAtt = Whitespace.trim(atts.getValue(a));
                    continue;
                }
                this.checkUnknownAttribute(atts.getNodeName(a));
                continue;
            }
            if (local.equals("memo-function") && uri.equals("http://saxon.sf.net/")) {
                this.memoFunction = this.processBooleanAttribute("saxon:memo-function", atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.nameAtt == null) {
            this.reportAbsence("name");
            this.nameAtt = "xsl:unnamed-function-" + this.generateId();
        }
        this.resultType = this.asAtt == null ? SequenceType.ANY_SEQUENCE : this.makeSequenceType(this.asAtt);
        if (visibilityAtt == null) {
            this.visibility = Visibility.PRIVATE;
        } else {
            this.check30attribute("visibility");
            this.visibility = this.interpretVisibilityValue(visibilityAtt, "");
        }
        if (streamabilityAtt == null) {
            this.streamability = FunctionStreamability.UNCLASSIFIED;
        } else {
            this.check30attribute("streamability");
            this.streamability = this.getStreamabilityValue(streamabilityAtt);
        }
        if (newEachTimeAtt != null) {
            if ("maybe".equals(newEachTimeAtt)) {
                this.determinism = UserFunction.Determinism.ELIDABLE;
            } else {
                try {
                    boolean b = this.processBooleanAttribute("new-each-time", newEachTimeAtt);
                    this.determinism = b ? UserFunction.Determinism.PROACTIVE : UserFunction.Determinism.DETERMINISTIC;
                }
                catch (XPathException e) {
                    this.invalidAttribute("new-each-time", "yes|no|maybe");
                }
            }
        }
        boolean cache = false;
        if (cacheAtt != null) {
            cache = this.processBooleanAttribute("cache", cacheAtt);
        }
        if (this.determinism == UserFunction.Determinism.DETERMINISTIC || cache) {
            this.memoFunction = true;
        }
    }

    private FunctionStreamability getStreamabilityValue(String s) throws XPathException {
        if (s.contains(":")) {
            try {
                this.makeQName(s);
            }
            catch (NamespaceException e) {
                throw new XPathException(e);
            }
            return FunctionStreamability.UNCLASSIFIED;
        }
        for (FunctionStreamability v : FunctionStreamability.values()) {
            if (!v.streamabilityStr.equals(s)) continue;
            return v;
        }
        this.invalidAttribute("visibility", "unclassified|absorbing|inspection|filter|shallow-descent|deep-descent|ascent");
        return null;
    }

    public StructuredQName getObjectName() {
        StructuredQName qn = super.getObjectName();
        if (qn == null) {
            this.nameAtt = Whitespace.trim(this.getAttributeValue("", "name"));
            if (this.nameAtt == null) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function" + this.generateId());
            }
            try {
                qn = this.makeQName(this.nameAtt);
                this.setObjectName(qn);
            }
            catch (NamespaceException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function" + this.generateId());
            }
            catch (XPathException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function" + this.generateId());
            }
        }
        return qn;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean mayContainParam(String attName) {
        return !"required".equals(attName);
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLLocalParam;
    }

    public Visibility getVisibility() {
        if (this.visibility == null) {
            try {
                String vAtt = this.getAttributeValue("", "visibility");
                return vAtt == null ? Visibility.PRIVATE : this.interpretVisibilityValue(Whitespace.trim(vAtt), "");
            }
            catch (XPathException e) {
                return Visibility.PRIVATE;
            }
        }
        return this.visibility;
    }

    public SymbolicName getSymbolicName() {
        return new SymbolicName(158, this.getObjectName(), this.getNumberOfArguments());
    }

    private void reportIncompatibility(String reason) throws XPathException {
        this.compileError("The overriding xsl:function " + this.nameAtt + " does not match the overridden function: " + reason, "XTSE3070");
    }

    public void checkCompatibility(Component component) throws XPathException {
        if (this.compiledFunction == null) {
            this.getCompiledFunction();
        }
        UserFunction other = (UserFunction)component.getCode();
        if (!this.compiledFunction.getSymbolicName().equals(other.getSymbolicName())) {
            this.reportIncompatibility("the function name/arity does not match");
        }
        if (!this.compiledFunction.getDeclaredResultType().equals(other.getDeclaredResultType())) {
            this.reportIncompatibility("the return type does not match");
        }
        if (!this.compiledFunction.getDeclaredStreamability().equals((Object)other.getDeclaredStreamability())) {
            this.reportIncompatibility("the streamability category does not match");
        }
        if (!this.compiledFunction.getDeterminism().equals((Object)other.getDeterminism())) {
            this.reportIncompatibility("the new-each-time attribute does not match");
        }
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            if (this.compiledFunction.getArgumentType(i).equals(other.getArgumentType(i))) continue;
            this.reportIncompatibility("the type of the " + RoleDiagnostic.ordinal(i + 1) + " argument does not match");
        }
    }

    public boolean isOverrideExtensionFunction() {
        if (this.overrideExtensionFunctionAtt == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return this.overrideExtensionFunction;
    }

    public void index(ComponentDeclaration decl, PrincipalStylesheetModule top) throws XPathException {
        this.getCompiledFunction();
        top.indexFunction(decl);
    }

    public void fixupReferences() throws XPathException {
        super.fixupReferences();
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel("XTSE0010", true);
        int arity = this.getNumberOfArguments();
        if (arity == 0 && this.streamability != FunctionStreamability.UNCLASSIFIED) {
            this.compileError("A function with no arguments must have streamability=unclassified", "XTSE3155");
        }
    }

    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        Component overridden;
        Expression exp = this.compileSequenceConstructor(compilation, decl, false);
        if (exp == null) {
            exp = Literal.makeEmptySequence();
        } else if (!Literal.isEmptySequence(exp)) {
            if (this.visibility == Visibility.ABSTRACT) {
                this.compileError("A function defined with visibility='abstract' must have no body");
            }
            exp = exp.simplify();
        }
        UserFunction fn = this.getCompiledFunction();
        fn.setBody(exp);
        fn.setStackFrameMap(this.stackFrameMap);
        this.bindParameterDefinitions(fn);
        fn.setRetainedStaticContext(this.makeRetainedStaticContext());
        if (this.memoFunction && !fn.isMemoFunction()) {
            this.compileWarning("Memo functions are not available in Saxon-HE: saxon:memo-function attribute ignored", "SXWN9011");
        }
        if ((overridden = this.getOverriddenComponent()) != null) {
            this.checkCompatibility(overridden);
        }
    }

    public void optimize(ComponentDeclaration declaration) throws XPathException {
        int tailCalls;
        Expression exp = this.compiledFunction.getBody();
        ExpressionTool.resetPropertiesWithinSubtree(exp);
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        Expression exp2 = exp.typeCheck(visitor, ContextItemStaticInfo.ABSENT);
        exp2 = ExpressionTool.optimizeComponentBody(exp2, this.getCompilation(), visitor, ContextItemStaticInfo.ABSENT, true);
        exp2 = XSLFunction.makeTraceInstruction(this, exp2);
        this.allocateLocalSlots(exp2);
        if (exp2 != exp) {
            this.compiledFunction.setBody(exp2);
        }
        if ((tailCalls = ExpressionTool.markTailFunctionCalls(exp2, this.getObjectName(), this.getNumberOfArguments())) != 0) {
            this.compiledFunction.setTailRecursive(tailCalls > 0, tailCalls > 1);
            this.compiledFunction.setBody(new TailCallLoop(this.compiledFunction, this.compiledFunction.getBody()));
        }
        this.compiledFunction.computeEvaluationMode();
        if (this.isExplaining()) {
            exp2.explain(this.getConfiguration().getLogger());
        }
    }

    public void generateByteCode(Optimizer opt) throws XPathException {
        if (this.getCompilation().getCompilerInfo().isGenerateByteCode()) {
            try {
                Expression cbody = opt.compileToByteCode(this.compiledFunction.getBody(), this.nameAtt, 6);
                if (cbody != null) {
                    this.compiledFunction.setBody(cbody);
                }
            }
            catch (Exception e) {
                System.err.println("Failed while compiling function " + this.nameAtt);
                e.printStackTrace();
                throw new XPathException(e);
            }
        }
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public SequenceType getResultType() {
        String asAtt;
        if (this.resultType == null && (asAtt = this.getAttributeValue("", "as")) != null) {
            try {
                this.resultType = this.makeSequenceType(asAtt);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return this.resultType == null ? SequenceType.ANY_SEQUENCE : this.resultType;
    }

    public int getNumberOfArguments() {
        if (this.numberOfArguments == -1) {
            NodeInfo child;
            this.numberOfArguments = 0;
            AxisIterator kids = this.iterateAxis((byte)3);
            while ((child = kids.next()) instanceof XSLLocalParam) {
                ++this.numberOfArguments;
            }
            return this.numberOfArguments;
        }
        return this.numberOfArguments;
    }

    public void setParameterDefinitions(UserFunction fn) {
        UserFunctionParameter[] params = new UserFunctionParameter[this.getNumberOfArguments()];
        fn.setParameterDefinitions(params);
        int count = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        while (true) {
            NodeInfo node;
            if ((node = kids.next()) == null) {
                return;
            }
            if (!(node instanceof XSLLocalParam)) break;
            UserFunctionParameter param = new UserFunctionParameter();
            params[count++] = param;
            param.setRequiredType(((XSLLocalParam)node).getRequiredType());
            param.setVariableQName(((XSLLocalParam)node).getVariableQName());
            param.setSlotNumber(((XSLLocalParam)node).getSlotNumber());
        }
    }

    public void bindParameterDefinitions(UserFunction fn) {
        UserFunctionParameter[] params = fn.getParameterDefinitions();
        int count = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo node;
        while ((node = kids.next()) != null) {
            if (!(node instanceof XSLLocalParam)) continue;
            UserFunctionParameter param = params[count++];
            param.setRequiredType(((XSLLocalParam)node).getRequiredType());
            param.setVariableQName(((XSLLocalParam)node).getVariableQName());
            param.setSlotNumber(((XSLLocalParam)node).getSlotNumber());
            ((XSLLocalParam)node).getSourceBinding().fixupBinding(param);
        }
        return;
    }

    public SequenceType[] getArgumentTypes() {
        SequenceType[] types = new SequenceType[this.getNumberOfArguments()];
        int count = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo node;
        while ((node = kids.next()) != null) {
            if (!(node instanceof XSLLocalParam)) continue;
            types[count++] = ((XSLLocalParam)node).getRequiredType();
        }
        return types;
    }

    public UserFunction getCompiledFunction() {
        if (this.compiledFunction == null) {
            try {
                this.prepareAttributes();
                UserFunction fn = this.getConfiguration().newUserFunction(this.memoFunction);
                fn.setPackageData(this.getCompilation().getPackageData());
                fn.setFunctionName(this.getObjectName());
                this.setParameterDefinitions(fn);
                fn.setResultType(this.getResultType());
                fn.setLineNumber(this.getLineNumber());
                fn.setSystemId(this.getSystemId());
                fn.makeDeclaringComponent(this.visibility, this.getContainingPackage());
                fn.setDeclaredVisibility(this.getDeclaredVisibility());
                fn.setDeclaredStreamability(this.streamability);
                fn.setDeterminism(this.determinism);
                this.compiledFunction = fn;
            }
            catch (XPathException err) {
                return null;
            }
        }
        return this.compiledFunction;
    }

    public int getConstructType() {
        return 158;
    }
}

