/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.domain;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Scanner;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.config.bootstrap.ArtifactType;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.internal.util.splash.SplashScreen;
import org.mule.runtime.deployment.model.api.DeploymentInitException;
import org.mule.runtime.deployment.model.api.DeploymentStartException;
import org.mule.runtime.deployment.model.api.DeploymentStopException;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactContextBuilder;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainStartedSplashScreen;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.mule.runtime.module.service.ServiceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleDomain
implements Domain {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DomainDescriptor descriptor;
    private final ServiceRepository serviceRepository;
    private MuleContextListener muleContextListener;
    private ArtifactClassLoader deploymentClassLoader;
    private final ClassLoaderRepository classLoaderRepository;
    private File configResourceFile;
    private ArtifactContext artifactContext;

    public DefaultMuleDomain(DomainDescriptor descriptor, ArtifactClassLoader deploymentClassLoader, ClassLoaderRepository classLoaderRepository, ServiceRepository serviceRepository) {
        this.deploymentClassLoader = deploymentClassLoader;
        this.classLoaderRepository = classLoaderRepository;
        this.descriptor = descriptor;
        this.serviceRepository = serviceRepository;
        this.refreshClassLoaderAndLoadConfigResourceFile();
    }

    private void refreshClassLoaderAndLoadConfigResourceFile() {
        URL resource = this.deploymentClassLoader.findLocalResource(DOMAIN_CONFIG_FILE_LOCATION);
        if (resource != null) {
            try {
                this.configResourceFile = new File(resource.toURI());
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    public void setMuleContextListener(MuleContextListener muleContextListener) {
        Preconditions.checkArgument((muleContextListener != null ? 1 : 0) != 0, (String)"muleContextListener cannot be null");
        this.muleContextListener = muleContextListener;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public MuleContext getMuleContext() {
        return this.artifactContext != null ? this.artifactContext.getMuleContext() : null;
    }

    public File getLocation() {
        return this.descriptor.getArtifactLocation();
    }

    public ConnectivityTestingService getConnectivityTestingService() {
        return this.artifactContext.getConnectivityTestingService();
    }

    public MetadataService getMetadataService() {
        return this.artifactContext.getMetadataService();
    }

    public void install() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SplashScreen.miniSplash((String)String.format("New domain '%s'", this.getArtifactName())));
        }
        this.refreshClassLoaderAndLoadConfigResourceFile();
    }

    public void init() {
        this.doInit(false);
    }

    public void lazyInit() {
        this.doInit(true);
    }

    public void doInit(boolean lazy) throws DeploymentInitException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SplashScreen.miniSplash((String)String.format("Initializing domain '%s'", this.getArtifactName())));
        }
        try {
            if (this.configResourceFile != null) {
                this.validateConfigurationFileDoNotUsesCoreNamespace();
                ArtifactContextBuilder artifactBuilder = ArtifactContextBuilder.newBuilder().setArtifactName(this.getArtifactName()).setExecutionClassloader(this.deploymentClassLoader.getClassLoader()).setArtifactInstallationDirectory(new File(MuleContainerBootstrapUtils.getMuleDomainsDir(), this.getArtifactName())).setConfigurationFiles(this.configResourceFile.getAbsolutePath()).setArtifactType(ArtifactType.DOMAIN).setEnableLazyInit(lazy).setClassLoaderRepository(this.classLoaderRepository).setServiceRepository(this.serviceRepository);
                if (this.muleContextListener != null) {
                    artifactBuilder.setMuleContextListener(this.muleContextListener);
                }
                this.artifactContext = artifactBuilder.build();
            }
        }
        catch (Exception e) {
            this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
            throw new DeploymentInitException(CoreMessages.createStaticMessage((String)ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
        }
    }

    private void validateConfigurationFileDoNotUsesCoreNamespace() throws FileNotFoundException {
        try (Scanner scanner = null;){
            scanner = new Scanner(this.configResourceFile);
            while (scanner.hasNextLine()) {
                String lineFromFile = scanner.nextLine();
                if (!lineFromFile.contains("<mule ")) continue;
                throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)"Domain configuration file can not be created using core namespace. Use mule-domain namespace instead."));
            }
        }
    }

    public void start() {
        try {
            if (this.artifactContext != null) {
                try {
                    this.artifactContext.getMuleContext().start();
                }
                catch (MuleException e) {
                    this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
                    throw new DeploymentStartException(CoreMessages.createStaticMessage((String)ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
                }
            }
            ClassUtils.withContextClassLoader(null, () -> {
                DomainStartedSplashScreen splashScreen = new DomainStartedSplashScreen();
                splashScreen.createMessage(this.descriptor);
                this.logger.info(splashScreen.toString());
            });
        }
        catch (Exception e) {
            throw new DeploymentStartException(CoreMessages.createStaticMessage((String)("Failure trying to start domain " + this.getArtifactName())), (Throwable)e);
        }
    }

    public void stop() {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(SplashScreen.miniSplash((String)String.format("Stopping domain '%s'", this.getArtifactName())));
            }
            if (this.artifactContext != null) {
                this.artifactContext.getMuleContext().stop();
            }
        }
        catch (Exception e) {
            throw new DeploymentStopException(CoreMessages.createStaticMessage((String)("Failure trying to stop domain " + this.getArtifactName())), (Throwable)e);
        }
    }

    public void dispose() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SplashScreen.miniSplash((String)String.format("Disposing domain '%s'", this.getArtifactName())));
        }
        if (this.artifactContext != null) {
            this.artifactContext.getMuleContext().dispose();
        }
        this.deploymentClassLoader.dispose();
    }

    public String getArtifactName() {
        return this.descriptor.getName();
    }

    public String getArtifactId() {
        return this.deploymentClassLoader.getArtifactId();
    }

    public DomainDescriptor getDescriptor() {
        return this.descriptor;
    }

    public File[] getResourceFiles() {
        File[] fileArray;
        if (this.configResourceFile == null) {
            fileArray = new File[]{};
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = this.configResourceFile;
        }
        return fileArray;
    }

    public ArtifactClassLoader getArtifactClassLoader() {
        return this.deploymentClassLoader;
    }

    public void initialise() {
        try {
            if (this.artifactContext != null) {
                this.artifactContext.getMuleContext().initialise();
            }
        }
        catch (InitialisationException e) {
            throw new DeploymentInitException(CoreMessages.createStaticMessage((String)("Failure trying to initialise domain " + this.getArtifactName())), (Throwable)e);
        }
    }

    public boolean containsSharedResources() {
        return this.artifactContext != null;
    }
}

