/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.deployment.meta;

import java.util.Optional;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.util.Preconditions;

public abstract class AbstractMuleArtifactModelBuilder<T extends AbstractMuleArtifactModelBuilder, M extends AbstractMuleArtifactModel> {
    private String name;
    private String minMuleVersion;
    private MuleArtifactLoaderDescriptor bundleDescriptorLoader;
    private Optional<MuleArtifactLoaderDescriptorBuilder> classLoaderDescriptorBuilder = Optional.empty();

    public T setName(String name) {
        this.name = name;
        return this.getThis();
    }

    public String getName() {
        return this.name;
    }

    protected abstract T getThis();

    public T setMinMuleVersion(String muleVersion) {
        this.minMuleVersion = muleVersion;
        return this.getThis();
    }

    public String getMinMuleVersion() {
        return this.minMuleVersion;
    }

    public MuleArtifactLoaderDescriptor getClassLoaderModelDescriptorLoader() {
        return this.classLoaderDescriptorBuilder.isPresent() ? this.classLoaderDescriptorBuilder.get().build() : null;
    }

    public T withBundleDescriptorLoader(MuleArtifactLoaderDescriptor bundleDescriptorLoader) {
        Preconditions.checkArgument(bundleDescriptorLoader != null, "bundleDescriptorLoader cannot be null");
        this.bundleDescriptorLoader = bundleDescriptorLoader;
        return this.getThis();
    }

    public MuleArtifactLoaderDescriptorBuilder withClassLoaderModelDescriber() {
        if (!this.classLoaderDescriptorBuilder.isPresent()) {
            this.classLoaderDescriptorBuilder = Optional.of(new MuleArtifactLoaderDescriptorBuilder());
        }
        return this.classLoaderDescriptorBuilder.get();
    }

    public MuleArtifactLoaderDescriptor getBundleDescriptorLoader() {
        return this.bundleDescriptorLoader;
    }

    public abstract M build();
}

