/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.app.declaration.serialization.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.runtime.api.app.declaration.ComponentElementDeclaration;
import org.mule.runtime.api.app.declaration.ConfigurationElementDeclaration;
import org.mule.runtime.api.app.declaration.ConnectionElementDeclaration;
import org.mule.runtime.api.app.declaration.FlowElementDeclaration;
import org.mule.runtime.api.app.declaration.GlobalElementDeclaration;
import org.mule.runtime.api.app.declaration.ParameterValue;
import org.mule.runtime.api.app.declaration.ParameterizedElementDeclaration;
import org.mule.runtime.api.app.declaration.TopLevelParameterDeclaration;
import org.mule.runtime.api.app.declaration.fluent.BaseElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ConnectionElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.EnrichableElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.FlowElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ParameterObjectValue;
import org.mule.runtime.api.app.declaration.fluent.ParameterizedElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.TopLevelParameterDeclarer;
import org.mule.runtime.internal.app.declaration.serialization.adapter.ElementDeclarationSerializationUtils;

class GlobalElementDeclarationTypeAdapter
extends TypeAdapter<GlobalElementDeclaration> {
    private final Gson delegate;

    GlobalElementDeclarationTypeAdapter(Gson delegate) {
        this.delegate = delegate;
    }

    public void write(JsonWriter out, GlobalElementDeclaration value) throws IOException {
        String kind = this.getKind(value);
        out.beginObject();
        out.name("refName").value(value.getRefName());
        if (value instanceof TopLevelParameterDeclaration) {
            ElementDeclarationSerializationUtils.populateIdentifiableObject(out, value, kind);
            ElementDeclarationSerializationUtils.populateCustomizableObject(this.delegate, out, value);
            ElementDeclarationSerializationUtils.populateMetadataAwareObject(this.delegate, out, value);
            out.name("value").jsonValue(this.delegate.toJson((Object)((TopLevelParameterDeclaration)value).getValue(), ParameterValue.class));
        } else {
            ElementDeclarationSerializationUtils.populateParameterizedObject(this.delegate, out, (ParameterizedElementDeclaration)((Object)value), kind);
            if (value instanceof ConfigurationElementDeclaration) {
                this.populateConnection(out, (ConfigurationElementDeclaration)value);
            } else if (value instanceof FlowElementDeclaration) {
                out.name("components").jsonValue(this.delegate.toJson(((FlowElementDeclaration)value).getComponents()));
            }
        }
        out.endObject();
    }

    public GlobalElementDeclaration read(JsonReader in) throws IOException {
        JsonElement parse = new JsonParser().parse(in);
        if (parse.isJsonObject()) {
            JsonObject jsonObject = parse.getAsJsonObject();
            JsonElement elementName = jsonObject.get("name");
            JsonElement elementKind = jsonObject.get("kind");
            JsonElement elementExtension = jsonObject.get("declaringExtension");
            if (elementKind != null && elementExtension != null && elementName != null) {
                Object declarer = this.getDeclarer(ElementDeclarer.forExtension(elementExtension.getAsString()), elementKind.getAsString(), elementName.getAsString());
                if (elementKind.getAsString().equals("GLOBAL_PARAMETER")) {
                    this.declareGlobalParameter(jsonObject, (EnrichableElementDeclarer)declarer);
                } else {
                    ElementDeclarationSerializationUtils.declareParameterizedElement(this.delegate, jsonObject, (ParameterizedElementDeclarer)declarer);
                    if (elementKind.getAsString().equals("CONFIG")) {
                        this.declareConfiguration(jsonObject, (ConfigurationElementDeclarer)declarer);
                    } else {
                        this.declareFlow(jsonObject, (FlowElementDeclarer)declarer);
                    }
                }
                return (GlobalElementDeclaration)((BaseElementDeclarer)declarer).getDeclaration();
            }
        }
        return null;
    }

    private void declareGlobalParameter(JsonObject jsonObject, EnrichableElementDeclarer declarer) {
        ElementDeclarationSerializationUtils.declareEnrichableElement(this.delegate, jsonObject, declarer);
        ((TopLevelParameterDeclarer)declarer).withRefName(jsonObject.get("refName").getAsString());
        ((TopLevelParameterDeclarer)declarer).withValue((ParameterObjectValue)this.delegate.fromJson(jsonObject.get("value"), ParameterObjectValue.class));
    }

    private void declareFlow(JsonObject jsonObject, FlowElementDeclarer declarer) {
        JsonArray components = jsonObject.get("components").getAsJsonArray();
        declarer.withRefName(jsonObject.get("refName").getAsString());
        components.forEach(c -> {
            FlowElementDeclarer cfr_ignored_0 = (FlowElementDeclarer)declarer.withComponent((ComponentElementDeclaration)this.delegate.fromJson(c, ComponentElementDeclaration.class));
        });
    }

    private void declareConfiguration(JsonObject configObject, ConfigurationElementDeclarer configDeclarer) {
        configDeclarer.withRefName(configObject.get("refName").getAsString());
        JsonElement connectionElement = configObject.get("connection");
        if (connectionElement != null && connectionElement.isJsonObject()) {
            JsonObject connectionObject = connectionElement.getAsJsonObject();
            JsonElement elementName = connectionObject.get("name");
            JsonElement elementExtension = connectionObject.get("declaringExtension");
            ConnectionElementDeclarer connectionDeclarer = ElementDeclarer.forExtension(elementExtension.getAsString()).newConnection(elementName.getAsString());
            ElementDeclarationSerializationUtils.declareParameterizedElement(this.delegate, connectionObject, connectionDeclarer);
            configDeclarer.withConnection((ConnectionElementDeclaration)connectionDeclarer.getDeclaration());
        }
    }

    private <T extends EnrichableElementDeclarer> T getDeclarer(ElementDeclarer declarer, String kind, String name) {
        switch (kind) {
            case "CONFIG": {
                return (T)declarer.newConfiguration(name);
            }
            case "GLOBAL_PARAMETER": {
                return (T)declarer.newGlobalParameter(name);
            }
            case "FLOW": {
                return (T)ElementDeclarer.newFlow();
            }
        }
        throw new IllegalArgumentException("Unknown kind: " + kind);
    }

    private String getKind(GlobalElementDeclaration type) {
        if (type instanceof TopLevelParameterDeclaration) {
            return "GLOBAL_PARAMETER";
        }
        if (type instanceof ConfigurationElementDeclaration) {
            return "CONFIG";
        }
        if (type instanceof FlowElementDeclaration) {
            return "FLOW";
        }
        throw new IllegalArgumentException("Unknown kind for type: " + type.getClass().getName());
    }

    private void populateConnection(JsonWriter out, ConfigurationElementDeclaration config) throws IOException {
        if (config.getConnection().isPresent()) {
            out.name("connection").beginObject();
            ElementDeclarationSerializationUtils.populateParameterizedObject(this.delegate, out, config.getConnection().get(), "CONNECTION");
            out.endObject();
        }
    }
}

