/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.model.resolvers;

import java.lang.reflect.Method;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.lifecycle.Callable;
import org.mule.runtime.core.api.model.EntryPointResolver;
import org.mule.runtime.core.api.model.InvocationResult;
import org.mule.runtime.core.config.i18n.CoreMessages;

public class CallableEntryPointResolver
implements EntryPointResolver {
    protected static final Method callableMethod;

    @Override
    public InvocationResult invoke(Object component, MuleEventContext context, Event.Builder eventBuilder) throws Exception {
        if (component instanceof Callable) {
            Object result = ((Callable)component).onCall(context);
            return new InvocationResult(this, result, callableMethod);
        }
        InvocationResult result = new InvocationResult(this, InvocationResult.State.NOT_SUPPORTED);
        result.setErrorMessage(CoreMessages.objectDoesNotImplementInterface(component, Callable.class).toString());
        return result;
    }

    public String toString() {
        return "CallableEntryPointResolver{}";
    }

    static {
        try {
            callableMethod = Callable.class.getMethod("onCall", MuleEventContext.class);
        }
        catch (NoSuchMethodException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Panic! No onCall(MuleEventContext) method found in the Callable interface."));
        }
    }
}

