/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.component;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.component.LifecycleAdapter;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.model.EntryPointResolverSet;
import org.mule.runtime.core.api.object.ObjectFactory;
import org.mule.runtime.core.api.registry.ServiceException;
import org.mule.runtime.core.component.AbstractJavaComponent;
import org.mule.runtime.core.config.i18n.CoreMessages;

public class DefaultJavaComponent
extends AbstractJavaComponent {
    protected LifecycleAdapter singletonComponentLifecycleAdapter;

    public DefaultJavaComponent() {
    }

    public DefaultJavaComponent(ObjectFactory objectFactory) {
        super(objectFactory);
    }

    public DefaultJavaComponent(ObjectFactory objectFactory, EntryPointResolverSet entryPointResolverSet) {
        super(objectFactory, entryPointResolverSet);
    }

    @Override
    protected void doStart() throws MuleException {
        super.doStart();
        if (this.objectFactory != null && this.objectFactory.isSingleton()) {
            try {
                if (this.singletonComponentLifecycleAdapter == null) {
                    this.singletonComponentLifecycleAdapter = this.createLifecycleAdaptor();
                }
            }
            catch (Exception e) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Unable to create instance of POJO service"), (Throwable)e, (Initialisable)this);
            }
            if (!this.singletonComponentLifecycleAdapter.isStarted()) {
                try {
                    this.singletonComponentLifecycleAdapter.start();
                }
                catch (Exception e) {
                    throw new ServiceException(CoreMessages.failedToStart("Service '" + this.flowConstruct.getName() + "'"), e);
                }
            }
        }
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.objectFactory);
    }

    @Override
    protected void doStop() throws MuleException {
        super.doStop();
        if (this.singletonComponentLifecycleAdapter != null && this.singletonComponentLifecycleAdapter.isStarted()) {
            try {
                this.singletonComponentLifecycleAdapter.stop();
            }
            catch (Exception e) {
                throw new ServiceException(CoreMessages.failedToStop("Service '" + this.flowConstruct.getName() + "'"), e);
            }
        }
    }

    @Override
    protected void doDispose() {
        super.doDispose();
        if (this.singletonComponentLifecycleAdapter != null) {
            this.singletonComponentLifecycleAdapter.dispose();
        }
    }

    @Override
    protected LifecycleAdapter borrowComponentLifecycleAdaptor() throws Exception {
        LifecycleAdapter componentLifecycleAdapter;
        if (this.singletonComponentLifecycleAdapter != null) {
            componentLifecycleAdapter = this.singletonComponentLifecycleAdapter;
        } else {
            componentLifecycleAdapter = this.createLifecycleAdaptor();
            componentLifecycleAdapter.start();
        }
        return componentLifecycleAdapter;
    }

    @Override
    protected void returnComponentLifecycleAdaptor(LifecycleAdapter lifecycleAdapter) throws Exception {
        if (this.singletonComponentLifecycleAdapter == null && lifecycleAdapter != null) {
            lifecycleAdapter.stop();
            lifecycleAdapter.dispose();
        }
    }
}

