/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.interceptor;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.interceptor.Interceptor;
import org.mule.runtime.core.processor.AbstractInterceptingMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerInterceptor
extends AbstractInterceptingMessageProcessor
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(TimerInterceptor.class);

    @Override
    public Event process(Event event) throws MuleException {
        long startTime = System.currentTimeMillis();
        Event resultEvent = this.processNext(event);
        if (logger.isInfoEnabled()) {
            long executionTime = System.currentTimeMillis() - startTime;
            logger.info(this.flowConstruct.getName() + " took " + executionTime + "ms to process event [" + resultEvent + "]");
        }
        return resultEvent;
    }
}

