/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.QueryEntityResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.extension.api.metadata.NullQueryMetadataResolver;

public final class DefaultMetadataResolverFactory
implements MetadataResolverFactory {
    private final OutputTypeResolver outputTypeResolver;
    private final AttributesTypeResolver attributesTypeResolver;
    private final Map<String, InputTypeResolver> inputResolvers = new HashMap<String, InputTypeResolver>();
    private final TypeKeysResolver keysResolver;

    public DefaultMetadataResolverFactory(Supplier<? extends TypeKeysResolver> keyResolver, Map<String, Supplier<? extends InputTypeResolver>> typeResolvers, Supplier<? extends OutputTypeResolver> outputResolver, Supplier<? extends AttributesTypeResolver> attributesResolver) {
        Preconditions.checkArgument((keyResolver != null ? 1 : 0) != 0, (String)"MetadataKeyResolver type cannot be null");
        Preconditions.checkArgument((typeResolvers != null ? 1 : 0) != 0, (String)"InputTypeResolvers cannot be null");
        Preconditions.checkArgument((outputResolver != null ? 1 : 0) != 0, (String)"OutputTypeResolver type cannot be null");
        Preconditions.checkArgument((attributesResolver != null ? 1 : 0) != 0, (String)"AttributesTypeResolver type cannot be null");
        typeResolvers.forEach((k, v) -> this.inputResolvers.put((String)k, (InputTypeResolver)v.get()));
        this.keysResolver = keyResolver.get();
        this.outputTypeResolver = outputResolver.get();
        this.attributesTypeResolver = attributesResolver.get();
        Preconditions.checkArgument((this.keysResolver != null ? 1 : 0) != 0, (String)"MetadataKeyResolver type cannot be null");
        this.inputResolvers.values().forEach(resolver -> Preconditions.checkArgument((resolver != null ? 1 : 0) != 0, (String)"Input Type Resolver cannot be null"));
        Preconditions.checkArgument((this.outputTypeResolver != null ? 1 : 0) != 0, (String)"OutputTypeResolver type cannot be null");
        Preconditions.checkArgument((this.attributesTypeResolver != null ? 1 : 0) != 0, (String)"AttributesTypeResolver type cannot be null");
    }

    public TypeKeysResolver getKeyResolver() {
        return this.keysResolver;
    }

    public <T> InputTypeResolver<T> getInputResolver(String parameterName) {
        return this.inputResolvers.getOrDefault(parameterName, (InputTypeResolver)new NullMetadataResolver());
    }

    public Collection<InputTypeResolver> getInputResolvers() {
        return Collections.unmodifiableCollection(this.inputResolvers.values());
    }

    public <T> OutputTypeResolver<T> getOutputResolver() {
        return this.outputTypeResolver;
    }

    public <T> AttributesTypeResolver<T> getOutputAttributesResolver() {
        return this.attributesTypeResolver;
    }

    public QueryEntityResolver getQueryEntityResolver() {
        return new NullQueryMetadataResolver();
    }
}

