/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.metadata;

import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;

public class SimpleDataType
implements DataType {
    private static final long serialVersionUID = -4590745924720880358L;
    protected final Class<?> type;
    protected final MediaType mimeType;
    protected final boolean streamType;

    SimpleDataType(Class<?> type, MediaType mimeType, boolean streamType) {
        this.type = type;
        this.mimeType = mimeType;
        this.streamType = streamType;
    }

    public Class<?> getType() {
        return this.type;
    }

    public MediaType getMediaType() {
        return this.mimeType;
    }

    public boolean isCompatibleWith(DataType dataType) {
        if (this == dataType) {
            return true;
        }
        if (dataType == null) {
            return false;
        }
        SimpleDataType that = (SimpleDataType)dataType;
        if ((this.getMediaType() == null && that.getMediaType() != null || that.getMediaType() == null && this.getMediaType() != null) && !MediaType.ANY.matches(this.mimeType) && !MediaType.ANY.matches(that.mimeType)) {
            return false;
        }
        if (!(this.getMediaType() == null || this.getMediaType().matches(that.getMediaType()) || MediaType.ANY.matches(that.getMediaType()) || MediaType.ANY.matches(this.getMediaType()))) {
            return false;
        }
        return this.fromPrimitive(this.getType()).isAssignableFrom(this.fromPrimitive(that.getType()));
    }

    private Class<?> fromPrimitive(Class<?> type) {
        Class<?> primitiveWrapper = this.getPrimitiveWrapper(type);
        if (primitiveWrapper != null) {
            return primitiveWrapper;
        }
        return type;
    }

    private Class<?> getPrimitiveWrapper(Class<?> primitiveType) {
        if (Boolean.TYPE.equals(primitiveType)) {
            return Boolean.class;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.class;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Byte.class;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Double.class;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.class;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleDataType that = (SimpleDataType)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        if ((this.mimeType == null && that.mimeType != null || that.mimeType == null && this.mimeType != null) && !MediaType.ANY.matches(that.mimeType)) {
            return false;
        }
        return this.mimeType == null || this.mimeType.matches(that.mimeType) || MediaType.ANY.matches(that.mimeType);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.mimeType != null ? this.mimeType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SimpleDataType{type=" + (this.type == null ? null : this.type.getName()) + ", mimeType='" + this.mimeType + '\'' + '}';
    }

    public boolean isStreamType() {
        return this.streamType;
    }
}

