/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.core.internal.util.ConcurrencyUtils;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamingBuffer {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractStreamingBuffer.class);
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T withReadLock(CheckedFunction<LockReleaser, T> function) {
        LockReleaser releaser = new LockReleaser(this.readLock);
        this.readLock.lock();
        try {
            T t = function.apply(releaser);
            return t;
        }
        finally {
            releaser.release();
        }
    }

    protected <T> T withWriteLock(CheckedSupplier<T> supplier) {
        return ConcurrencyUtils.withLock(this.writeLock, supplier);
    }

    protected void checkNotClosed() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (String)"Buffer is closed");
    }

    protected void closeSafely(CheckedRunnable task) {
        FunctionalUtils.safely(task, e -> LOGGER.debug("Found exception closing buffer", (Throwable)e));
    }

    public final class LockReleaser {
        private final Lock lock;
        private boolean acquired = true;

        private LockReleaser(Lock lock) {
            this.lock = lock;
        }

        public void release() {
            if (this.acquired) {
                try {
                    this.lock.unlock();
                }
                finally {
                    this.acquired = false;
                }
            }
        }
    }
}

