/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;

abstract class AbstractCursorStream
extends CursorStream {
    private final CursorStreamProvider provider;
    private long mark = 0L;
    private boolean released = false;
    protected long position = 0L;

    public AbstractCursorStream(CursorStreamProvider provider) {
        this.provider = provider;
    }

    public long getPosition() {
        return this.position;
    }

    public void seek(long position) throws IOException {
        this.assertNotDisposed();
        this.position = position;
    }

    public boolean isReleased() {
        return this.released;
    }

    public final synchronized void release() {
        if (!this.released) {
            this.released = true;
        }
    }

    public CursorStreamProvider getProvider() {
        return this.provider;
    }

    protected void assertNotDisposed() throws IOException {
        if (this.released) {
            throw new IOException("Stream is closed");
        }
    }

    public final void close() throws IOException {
        if (!this.released) {
            this.release();
        }
    }

    public final int read() throws IOException {
        this.assertNotDisposed();
        return this.doRead();
    }

    protected abstract int doRead() throws IOException;

    public int read(byte[] b, int off, int len) throws IOException {
        this.assertNotDisposed();
        return this.doRead(b, off, len);
    }

    protected abstract int doRead(byte[] var1, int var2, int var3) throws IOException;

    public final long skip(long n) throws IOException {
        this.seek(this.getPosition() + n);
        return n;
    }

    public synchronized void mark(int readlimit) {
        this.mark = readlimit;
    }

    public synchronized void reset() throws IOException {
        this.seek(this.mark);
    }

    public boolean markSupported() {
        return true;
    }

    protected int unsigned(int value) {
        return value & 0xFF;
    }
}

