/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.execution.MessageProcessorExecutionTemplate;
import org.mule.runtime.core.processor.AbstractInterceptingMessageProcessor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ResponseMessageProcessorAdapter
extends AbstractInterceptingMessageProcessor
implements Lifecycle,
FlowConstructAware {
    protected MessageProcessorExecutionTemplate messageProcessorExecutionTemplate = MessageProcessorExecutionTemplate.createExecutionTemplate();
    protected Processor responseProcessor;

    public ResponseMessageProcessorAdapter() {
    }

    public ResponseMessageProcessorAdapter(Processor responseProcessor) {
        this.responseProcessor = responseProcessor;
    }

    public void setProcessor(Processor processor) {
        this.responseProcessor = processor;
    }

    @Override
    public Event process(Event event) throws MuleException {
        Event response = this.processNext(event);
        if (this.responseProcessor == null || !this.isEventValid(response)) {
            return response;
        }
        return this.resolveReturnEvent(this.responseProcessor.process(response), response);
    }

    private Event resolveReturnEvent(Event result, Event original) {
        if (result == null) {
            return original;
        }
        return result;
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        if (this.responseProcessor == null) {
            return publisher;
        }
        return Flux.from(publisher).transform((Function)this.applyNext()).flatMap(event -> Flux.from(MessageProcessors.processWithChildContext(event, this.responseProcessor)).defaultIfEmpty(event));
    }

    public void initialise() throws InitialisationException {
        if (this.responseProcessor instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.responseProcessor)).setMuleContext(this.muleContext);
        }
        if (this.responseProcessor instanceof FlowConstructAware) {
            ((FlowConstructAware)((Object)this.responseProcessor)).setFlowConstruct(this.flowConstruct);
        }
        if (this.responseProcessor instanceof Initialisable) {
            ((Initialisable)this.responseProcessor).initialise();
        }
    }

    public void start() throws MuleException {
        if (this.responseProcessor instanceof Startable) {
            ((Startable)this.responseProcessor).start();
        }
    }

    public void stop() throws MuleException {
        if (this.responseProcessor instanceof Stoppable) {
            ((Stoppable)this.responseProcessor).stop();
        }
    }

    public void dispose() {
        if (this.responseProcessor instanceof Disposable) {
            ((Disposable)this.responseProcessor).dispose();
        }
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
        LifecycleUtils.setFlowConstructIfNeeded(this.responseProcessor, flowConstruct);
        this.messageProcessorExecutionTemplate.setFlowConstruct(flowConstruct);
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        LifecycleUtils.setMuleContextIfNeeded(this.responseProcessor, muleContext);
        this.messageProcessorExecutionTemplate.setMuleContext(muleContext);
    }
}

