/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.store;

import java.io.Serializable;
import java.util.function.Supplier;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;

public class ProvidedObjectStoreWrapper<T extends Serializable>
implements ObjectStore<T>,
Disposable {
    private ObjectStore<T> wrapped;
    private final boolean provided;

    public ProvidedObjectStoreWrapper(ObjectStore<T> providedObjectStore, Supplier<ObjectStore> objectStoreSupplier) {
        if (providedObjectStore == null) {
            this.provided = false;
            this.wrapped = objectStoreSupplier.get();
        } else {
            this.provided = true;
            this.wrapped = providedObjectStore;
        }
    }

    public boolean contains(Serializable key) throws ObjectStoreException {
        return this.getWrapped().contains(key);
    }

    public void store(Serializable key, T value) throws ObjectStoreException {
        this.getWrapped().store(key, value);
    }

    public T retrieve(Serializable key) throws ObjectStoreException {
        return (T)this.getWrapped().retrieve(key);
    }

    public T remove(Serializable key) throws ObjectStoreException {
        return (T)this.getWrapped().remove(key);
    }

    public boolean isPersistent() {
        return this.getWrapped().isPersistent();
    }

    public void clear() throws ObjectStoreException {
        this.getWrapped().clear();
    }

    public void dispose() {
        if (!this.provided && this.wrapped != null && this.wrapped instanceof Disposable) {
            ((Disposable)this.wrapped).dispose();
        }
        this.wrapped = null;
    }

    protected ObjectStore<T> getWrapped() {
        return this.wrapped;
    }
}

