/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.xmlsecurity;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerFactory;
import org.mule.runtime.core.util.xmlsecurity.DefaultXMLSecureFactories;
import org.mule.runtime.core.util.xmlsecurity.XMLSecureFactoriesCache;

public class XMLSecureFactories {
    public static final String EXTERNAL_ENTITIES_PROPERTY = "mule.xml.expandExternalEntities";
    public static final String EXPAND_ENTITIES_PROPERTY = "mule.xml.expandInternalEntities";
    private Boolean externalEntities;
    private Boolean expandEntities;

    public static XMLSecureFactories createWithConfig(Boolean externalEntities, Boolean expandEntities) {
        XMLSecureFactories factory = new XMLSecureFactories();
        factory.externalEntities = externalEntities;
        factory.expandEntities = expandEntities;
        return factory;
    }

    public static XMLSecureFactories createDefault() {
        return new XMLSecureFactories();
    }

    private XMLSecureFactories() {
        String externalEntitiesValue = System.getProperty(EXTERNAL_ENTITIES_PROPERTY, "false");
        this.externalEntities = Boolean.parseBoolean(externalEntitiesValue);
        String expandEntitiesValue = System.getProperty(EXPAND_ENTITIES_PROPERTY, "false");
        this.expandEntities = Boolean.parseBoolean(expandEntitiesValue);
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return XMLSecureFactoriesCache.getInstance().getDocumentBuilderFactory(this.externalEntities, this.expandEntities);
    }

    public SAXParserFactory getSAXParserFactory() {
        return XMLSecureFactoriesCache.getInstance().getSAXParserFactory(this.externalEntities, this.expandEntities);
    }

    public XMLInputFactory getXMLInputFactory() {
        return XMLSecureFactoriesCache.getInstance().getXMLInputFactory(this.externalEntities, this.expandEntities);
    }

    public TransformerFactory getTransformerFactory() {
        return XMLSecureFactoriesCache.getInstance().getTransformerFactory(this.externalEntities, this.expandEntities);
    }

    public TransformerFactory getSaxonTransformerFactory() {
        return XMLSecureFactoriesCache.getInstance().getSaxonTransformerFactory(this.externalEntities, this.expandEntities);
    }

    public void configureTransformerFactory(TransformerFactory factory) {
        DefaultXMLSecureFactories.configureTransformerFactory(this.externalEntities, this.expandEntities, factory);
    }
}

