/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.SerializedSubscriber;

final class DelegateProcessor<IN, OUT>
extends FluxProcessor<IN, OUT> {
    final Publisher<OUT> downstream;
    final Subscriber<IN> upstream;

    DelegateProcessor(Publisher<OUT> downstream, Subscriber<IN> upstream) {
        this.downstream = Objects.requireNonNull(downstream, "Downstream must not be null");
        this.upstream = Objects.requireNonNull(upstream, "Upstream must not be null");
    }

    public void onComplete() {
        this.upstream.onComplete();
    }

    public void onError(Throwable t) {
        this.upstream.onError(t);
    }

    public void onNext(IN in) {
        this.upstream.onNext(in);
    }

    public void onSubscribe(Subscription s) {
        this.upstream.onSubscribe(s);
    }

    @Override
    public void subscribe(Subscriber<? super OUT> s) {
        if (s == null) {
            throw Exceptions.argumentIsNullException();
        }
        this.downstream.subscribe(s);
    }

    @Override
    public boolean isSerialized() {
        return this.upstream instanceof SerializedSubscriber || this.upstream instanceof FluxProcessor && ((FluxProcessor)this.upstream).isSerialized();
    }

    @Override
    public Stream<? extends Scannable> inners() {
        return Scannable.from(this.upstream).inners();
    }

    @Override
    public int getBufferSize() {
        return Scannable.from(this.upstream).scanOrDefault(Scannable.Attr.CAPACITY, super.getBufferSize());
    }

    @Override
    public Throwable getError() {
        return Scannable.from(this.upstream).scanOrDefault(Scannable.Attr.ERROR, super.getError());
    }

    @Override
    @Deprecated
    public boolean isStarted() {
        return !(this.upstream instanceof FluxProcessor) || ((FluxProcessor)this.upstream).isStarted();
    }

    @Override
    public boolean isTerminated() {
        return Scannable.from(this.upstream).scanOrDefault(Scannable.Attr.TERMINATED, super.isTerminated());
    }

    @Override
    public Object scan(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.downstream;
        }
        return Scannable.from(this.upstream).scan(key);
    }
}

