/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerProducer;

final class FluxJust<T>
extends Flux<T>
implements Fuseable.ScalarCallable<T>,
Fuseable {
    final T value;

    FluxJust(T value) {
        this.value = Objects.requireNonNull(value, "value");
    }

    @Override
    public T call() {
        return this.value;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        subscriber.onSubscribe(new WeakScalarSubscription<T>(this.value, subscriber));
    }

    static final class WeakScalarSubscription<T>
    implements Fuseable.QueueSubscription<T>,
    InnerProducer<T> {
        boolean terminado;
        final T value;
        final Subscriber<? super T> actual;

        WeakScalarSubscription(T value, Subscriber<? super T> actual) {
            this.value = value;
            this.actual = actual;
        }

        public void request(long elements) {
            if (this.terminado) {
                return;
            }
            this.terminado = true;
            if (this.value != null) {
                this.actual.onNext(this.value);
            }
            this.actual.onComplete();
        }

        public void cancel() {
            this.terminado = true;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 1) != 0) {
                return 1;
            }
            return 0;
        }

        @Override
        public T poll() {
            if (!this.terminado) {
                this.terminado = true;
                return this.value;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.terminado;
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }

        @Override
        public void clear() {
            this.terminado = true;
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: 
                case CANCELLED: {
                    return this.terminado;
                }
            }
            return InnerProducer.super.scan(key);
        }
    }
}

