/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.LinkedList;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.AssemblyOp;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuples;

final class FluxOnAssembly<T>
extends FluxSource<T, T>
implements Fuseable,
AssemblyOp {
    final AssemblySnapshotException snapshotStack;
    static final boolean fullStackTrace = Boolean.parseBoolean(System.getProperty("reactor.trace.assembly.fullstacktrace", "false"));

    FluxOnAssembly(Flux<? extends T> source) {
        super(source);
        this.snapshotStack = new AssemblySnapshotException();
    }

    FluxOnAssembly(Flux<? extends T> source, String description) {
        super(source);
        this.snapshotStack = new AssemblySnapshotException(description);
    }

    static String getStacktrace(Publisher<?> source, AssemblySnapshotException snapshotStack) {
        StackTraceElement[] stes = snapshotStack.getStackTrace();
        StringBuilder sb = new StringBuilder();
        if (null != source) {
            FluxOnAssembly.fillStacktraceHeader(sb, source.getClass(), snapshotStack);
        }
        for (StackTraceElement e : stes) {
            String row = e.toString();
            if (!fullStackTrace && (e.getLineNumber() <= 1 || row.contains("reactor.core.publisher.Flux.onAssembly") || row.contains("reactor.core.publisher.Mono.onAssembly") || row.contains("reactor.core.publisher.ParallelFlux.onAssembly") || row.contains("reactor.core.publisher.SignalLogger") || row.contains("FluxOnAssembly.") || row.contains("MonoOnAssembly.") || row.contains("MonoCallableOnAssembly.") || row.contains("FluxCallableOnAssembly.") || row.contains("OnOperatorHook") || row.contains("operatorStacktrace") || row.contains("reactor.core.publisher.Hooks") || row.contains(".junit.runner") || row.contains(".junit4.runner") || row.contains(".junit.internal") || row.contains("sun.reflect") || row.contains("useTraceAssembly") || row.contains("java.lang.Thread.") || row.contains("ThreadPoolExecutor") || row.contains("org.apache.catalina.") || row.contains("org.apache.tomcat.") || row.contains("com.intellij.") || row.contains("java.lang.reflect"))) continue;
            sb.append("\t").append(row).append("\n");
        }
        return sb.toString();
    }

    static void fillStacktraceHeader(StringBuilder sb, Class<?> sourceClass, AssemblySnapshotException ase) {
        sb.append("\nAssembly trace from producer [").append(sourceClass.getName()).append("]");
        if (ase.getMessage() != null) {
            sb.append(", described as [").append(ase.getMessage()).append("]");
        }
        sb.append(" :\n");
    }

    static <T> void subscribe(Subscriber<? super T> s, Publisher<? extends T> source, AssemblySnapshotException snapshotStack) {
        if (snapshotStack != null) {
            if (s instanceof Fuseable.ConditionalSubscriber) {
                Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
                source.subscribe(new OnAssemblyConditionalSubscriber(cs, snapshotStack, source));
            } else {
                source.subscribe(new OnAssemblySubscriber<T>(s, snapshotStack, source));
            }
        }
    }

    static String extract(String source, boolean skipFirst) {
        String usercode = null;
        String last = null;
        boolean first = skipFirst;
        for (String s : source.split("\n")) {
            if (s.isEmpty()) continue;
            if (first) {
                first = false;
                continue;
            }
            if (!s.contains("reactor.core.publisher")) {
                usercode = s.substring(s.indexOf(40));
                break;
            }
            if (last != null) continue;
            last = s.replace("reactor.core.publisher.", "");
            last = last.substring(0, last.indexOf("("));
        }
        return (skipFirst && last != null ? last : "") + usercode;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        FluxOnAssembly.subscribe(s, this.source, this.snapshotStack);
    }

    static int getParentOrThis(Scannable parent) {
        return parent.parents().filter(s -> !(s instanceof AssemblyOp)).findFirst().map(Object::hashCode).orElse(parent.hashCode());
    }

    static final class OnAssemblyConditionalSubscriber<T>
    extends OnAssemblySubscriber<T>
    implements Fuseable.ConditionalSubscriber<T> {
        final Fuseable.ConditionalSubscriber<? super T> actualCS;

        OnAssemblyConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, AssemblySnapshotException stacktrace, Publisher<?> parent) {
            super(actual, stacktrace, parent);
            this.actualCS = actual;
        }

        @Override
        public boolean tryOnNext(T t) {
            return this.actualCS.tryOnNext(t);
        }
    }

    static class OnAssemblySubscriber<T>
    implements InnerOperator<T, T>,
    Fuseable.QueueSubscription<T>,
    InnerProducer<T> {
        final AssemblySnapshotException snapshotStack;
        final Publisher<?> parent;
        final Subscriber<? super T> actual;
        Fuseable.QueueSubscription<T> qs;
        Subscription s;
        int fusionMode;

        OnAssemblySubscriber(Subscriber<? super T> actual, AssemblySnapshotException snapshotStack, Publisher<?> parent) {
            this.actual = actual;
            this.snapshotStack = snapshotStack;
            this.parent = parent;
        }

        @Override
        public final Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
            }
            return InnerOperator.super.scan(key);
        }

        public final void onNext(T t) {
            this.actual.onNext(t);
        }

        public final void onError(Throwable t) {
            this.fail(t);
            this.actual.onError(t);
        }

        public final void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public final int requestFusion(int requestedMode) {
            Fuseable.QueueSubscription<T> qs = this.qs;
            if (qs != null) {
                int m = qs.requestFusion(requestedMode);
                if (m != 0) {
                    this.fusionMode = m;
                }
                return m;
            }
            return 0;
        }

        final void fail(Throwable t) {
            OnAssemblyException set = null;
            if (t.getSuppressed().length > 0) {
                for (Throwable e : t.getSuppressed()) {
                    if (!(e instanceof OnAssemblyException)) continue;
                    OnAssemblyException oae = (OnAssemblyException)e;
                    oae.add(this.parent, FluxOnAssembly.getStacktrace(this.parent, this.snapshotStack));
                    set = oae;
                    break;
                }
            }
            if (set == null) {
                t.addSuppressed(new OnAssemblyException(FluxOnAssembly.getStacktrace(this.parent, this.snapshotStack), this.parent));
            } else if (this.snapshotStack.checkpointed && t != this.snapshotStack) {
                t.addSuppressed(this.snapshotStack);
            }
        }

        @Override
        public final boolean isEmpty() {
            try {
                return this.qs.isEmpty();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.fail(ex);
                throw ex;
            }
        }

        public final void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.qs = Operators.as(s);
                this.actual.onSubscribe((Subscription)this);
            }
        }

        @Override
        public final int size() {
            return this.qs.size();
        }

        @Override
        public final void clear() {
            this.qs.clear();
        }

        public final void request(long n) {
            this.s.request(n);
        }

        public final void cancel() {
            this.s.cancel();
        }

        @Override
        public final T poll() {
            try {
                return (T)this.qs.poll();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.fail(ex);
                throw ex;
            }
        }
    }

    static final class OnAssemblyException
    extends RuntimeException {
        final List<Tuple3<Integer, String, Integer>> chainOrder = new LinkedList<Tuple3<Integer, String, Integer>>();
        private static final long serialVersionUID = 5278398300974016773L;

        OnAssemblyException(String message, Publisher<?> parent) {
            super(message);
            this.chainOrder.add(Tuples.of(parent.hashCode(), FluxOnAssembly.extract(message, true), 0));
        }

        void mapLine(int indent, StringBuilder sb, String s) {
            for (int i = 0; i < indent; ++i) {
                sb.append("\t");
            }
            sb.append("\t|_").append(s).append("\n");
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(Publisher<?> parent, String stacktrace) {
            int key = FluxOnAssembly.getParentOrThis(Scannable.from(parent));
            List<Tuple3<Integer, String, Integer>> list = this.chainOrder;
            synchronized (list) {
                Tuple3<Integer, String, Integer> t;
                int i = 0;
                int n = this.chainOrder.size();
                for (int j = n - 1; j >= 0; --j) {
                    Tuple3<Integer, String, Integer> tmp = this.chainOrder.get(j);
                    if ((Integer)tmp.getT1() != key) continue;
                    i = tmp.getT3();
                    break;
                }
                while (true) {
                    if (!this.chainOrder.contains(t = Tuples.of(parent.hashCode(), FluxOnAssembly.extract(stacktrace, true), i))) break;
                    ++i;
                }
                this.chainOrder.add(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder(super.getMessage()).append("Error has been observed by the following operator(s):\n");
            List<Tuple3<Integer, String, Integer>> list = this.chainOrder;
            synchronized (list) {
                for (Tuple3<Integer, String, Integer> t : this.chainOrder) {
                    this.mapLine(t.getT3(), sb, (String)t.getT2());
                }
            }
            return sb.toString();
        }
    }

    static final class AssemblySnapshotException
    extends RuntimeException {
        final boolean checkpointed;

        AssemblySnapshotException() {
            this.checkpointed = false;
        }

        AssemblySnapshotException(String description) {
            super(description);
            this.checkpointed = true;
        }
    }
}

