/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxOnBackpressureLatest<T>
extends FluxSource<T, T> {
    FluxOnBackpressureLatest(Flux<? extends T> source) {
        super(source);
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new LatestSubscriber<T>(s));
    }

    @Override
    public long getPrefetch() {
        return Integer.MAX_VALUE;
    }

    static final class LatestSubscriber<T>
    implements InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        volatile long requested;
        static final AtomicLongFieldUpdater<LatestSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(LatestSubscriber.class, "requested");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<LatestSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(LatestSubscriber.class, "wip");
        Subscription s;
        Throwable error;
        volatile boolean done;
        volatile boolean cancelled;
        volatile T value;
        static final AtomicReferenceFieldUpdater<LatestSubscriber, Object> VALUE = AtomicReferenceFieldUpdater.newUpdater(LatestSubscriber.class, Object.class, "value");

        LatestSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                if (WIP.getAndIncrement(this) == 0) {
                    VALUE.lazySet(this, null);
                }
            }
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            VALUE.lazySet(this, t);
            this.drain();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            Subscriber<? super T> a = this.actual;
            int missed = 1;
            do {
                long e;
                if (this.checkTerminated(this.done, this.value == null, a)) {
                    return;
                }
                long r = this.requested;
                for (e = 0L; r != e; ++e) {
                    boolean empty;
                    boolean d = this.done;
                    Object v = VALUE.getAndSet(this, null);
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(d, empty, a)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(v);
                }
                if (r == e && this.checkTerminated(this.done, this.value == null, a)) {
                    return;
                }
                if (e == 0L || r == Long.MAX_VALUE) continue;
                REQUESTED.addAndGet(this, -e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a) {
            if (this.cancelled) {
                VALUE.lazySet(this, null);
                return true;
            }
            if (d) {
                Throwable e = this.error;
                if (e != null) {
                    VALUE.lazySet(this, null);
                    a.onError(e);
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
                case TERMINATED: {
                    return this.done;
                }
                case CANCELLED: {
                    return this.cancelled;
                }
                case BUFFERED: {
                    return this.value != null;
                }
                case ERROR: {
                    return this.error;
                }
                case PREFETCH: {
                    return Integer.MAX_VALUE;
                }
            }
            return InnerOperator.super.scan(key);
        }
    }
}

