/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxOnErrorResume<T>
extends FluxSource<T, T> {
    final Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory;

    FluxOnErrorResume(Flux<? extends T> source, Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory) {
        super(source);
        this.nextFactory = Objects.requireNonNull(nextFactory, "nextFactory");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new ResumeSubscriber<T>(s, this.nextFactory));
    }

    static final class ResumeSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory;
        boolean second;

        ResumeSubscriber(Subscriber<? super T> actual, Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory) {
            super(actual);
            this.nextFactory = nextFactory;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (!this.second) {
                this.actual.onSubscribe((Subscription)this);
            }
            this.set(s);
        }

        public void onNext(T t) {
            this.actual.onNext(t);
            if (!this.second) {
                this.producedOne();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (!this.second) {
                Publisher<? extends T> p;
                this.second = true;
                try {
                    p = Objects.requireNonNull(this.nextFactory.apply(t), "The nextFactory returned a null Publisher");
                }
                catch (Throwable e) {
                    Throwable _e = Operators.onOperatorError(e);
                    if (t != _e) {
                        _e.addSuppressed(t);
                    }
                    this.actual.onError(_e);
                    return;
                }
                p.subscribe((Subscriber)this);
            } else {
                this.actual.onError(t);
            }
        }
    }
}

