/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.Operators;

final class FluxRepeatWhen<T>
extends FluxSource<T, T> {
    final Function<? super Flux<Long>, ? extends Publisher<?>> whenSourceFactory;

    FluxRepeatWhen(Publisher<? extends T> source, Function<? super Flux<Long>, ? extends Publisher<?>> whenSourceFactory) {
        super(source);
        this.whenSourceFactory = Objects.requireNonNull(whenSourceFactory, "whenSourceFactory");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        Publisher<?> p;
        RepeatWhenOtherSubscriber other = new RepeatWhenOtherSubscriber();
        Subscriber<Long> signaller = Operators.serialize(other.completionSignal);
        signaller.onSubscribe(Operators.emptySubscription());
        Subscriber<? super T> serial = Operators.serialize(s);
        RepeatWhenMainSubscriber<? super T> main = new RepeatWhenMainSubscriber<T>(serial, signaller, this.source);
        other.main = main;
        serial.onSubscribe(main);
        try {
            p = Objects.requireNonNull(this.whenSourceFactory.apply(other), "The whenSourceFactory returned a null Publisher");
        }
        catch (Throwable e) {
            s.onError(Operators.onOperatorError(e));
            return;
        }
        p.subscribe((Subscriber)other);
        if (!main.cancelled) {
            this.source.subscribe(main);
        }
    }

    static final class RepeatWhenOtherSubscriber
    extends Flux<Long>
    implements InnerConsumer<Object> {
        RepeatWhenMainSubscriber<?> main;
        final DirectProcessor<Long> completionSignal = new DirectProcessor();

        RepeatWhenOtherSubscriber() {
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.main.otherArbiter;
                }
                case ACTUAL: {
                    return this.main;
                }
            }
            return null;
        }

        public void onSubscribe(Subscription s) {
            this.main.setWhen(s);
        }

        public void onNext(Object t) {
            this.main.resubscribe();
        }

        public void onError(Throwable t) {
            this.main.whenError(t);
        }

        public void onComplete() {
            this.main.whenComplete();
        }

        public void subscribe(Subscriber<? super Long> s) {
            this.completionSignal.subscribe((Subscriber<Long>)s);
        }
    }

    static final class RepeatWhenMainSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Operators.DeferredSubscription otherArbiter;
        final Subscriber<Long> signaller;
        final Publisher<? extends T> source;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<RepeatWhenMainSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(RepeatWhenMainSubscriber.class, "wip");
        volatile boolean cancelled;
        long produced;

        RepeatWhenMainSubscriber(Subscriber<? super T> actual, Subscriber<Long> signaller, Publisher<? extends T> source) {
            super(actual);
            this.signaller = signaller;
            this.source = source;
            this.otherArbiter = new Operators.DeferredSubscription();
        }

        @Override
        public Object scan(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled;
            }
            return super.scan(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(Scannable.from(this.signaller), this.otherArbiter);
        }

        @Override
        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.cancelWhen();
            super.cancel();
        }

        public void onNext(T t) {
            this.actual.onNext(t);
            ++this.produced;
        }

        @Override
        public void onError(Throwable t) {
            this.otherArbiter.cancel();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            long p = this.produced;
            if (p != 0L) {
                this.produced = 0L;
                this.produced(p);
            }
            this.otherArbiter.request(1L);
            this.signaller.onNext((Object)p);
        }

        void cancelWhen() {
            this.otherArbiter.cancel();
        }

        void setWhen(Subscription w) {
            this.otherArbiter.set(w);
        }

        void resubscribe() {
            if (WIP.getAndIncrement(this) == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    this.source.subscribe((Subscriber)this);
                } while (WIP.decrementAndGet(this) != 0);
            }
        }

        void whenError(Throwable e) {
            this.cancelled = true;
            super.cancel();
            this.actual.onError(e);
        }

        void whenComplete() {
            this.cancelled = true;
            super.cancel();
            this.actual.onComplete();
        }
    }
}

