/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;

final class FluxSampleTimeout<T, U>
extends FluxSource<T, T> {
    final Function<? super T, ? extends Publisher<U>> throttler;
    final Supplier<Queue<Object>> queueSupplier;

    FluxSampleTimeout(Flux<? extends T> source, Function<? super T, ? extends Publisher<U>> throttler, Supplier<Queue<Object>> queueSupplier) {
        super(source);
        this.throttler = Objects.requireNonNull(throttler, "throttler");
        this.queueSupplier = Objects.requireNonNull(queueSupplier, "queueSupplier");
    }

    @Override
    public long getPrefetch() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        Queue<Object> q = this.queueSupplier.get();
        SampleTimeoutMain main = new SampleTimeoutMain(s, this.throttler, q);
        s.onSubscribe(main);
        this.source.subscribe(main);
    }

    static final class SampleTimeoutOther<T, U>
    extends Operators.DeferredSubscription
    implements InnerConsumer<U> {
        final SampleTimeoutMain<T, U> main;
        final T value;
        final long index;
        volatile int once;
        static final AtomicIntegerFieldUpdater<SampleTimeoutOther> ONCE = AtomicIntegerFieldUpdater.newUpdater(SampleTimeoutOther.class, "once");

        SampleTimeoutOther(SampleTimeoutMain<T, U> main, T value, long index) {
            this.main = main;
            this.value = value;
            this.index = index;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.once == 1;
                }
                case ACTUAL: {
                    return this.main;
                }
            }
            return super.scan(key);
        }

        public void onSubscribe(Subscription s) {
            if (this.set(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(U t) {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.cancel();
                this.main.otherNext(this);
            }
        }

        public void onError(Throwable t) {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.main.otherError(this.index, t);
            } else {
                Operators.onErrorDropped(t);
            }
        }

        public void onComplete() {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.main.otherNext(this);
            }
        }
    }

    static final class SampleTimeoutMain<T, U>
    implements InnerOperator<T, T>,
    InnerProducer<T> {
        final Function<? super T, ? extends Publisher<U>> throttler;
        final Queue<SampleTimeoutOther<T, U>> queue;
        final Subscriber<? super T> actual;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<SampleTimeoutMain, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(SampleTimeoutMain.class, Subscription.class, "s");
        volatile Subscription other;
        static final AtomicReferenceFieldUpdater<SampleTimeoutMain, Subscription> OTHER = AtomicReferenceFieldUpdater.newUpdater(SampleTimeoutMain.class, Subscription.class, "other");
        volatile long requested;
        static final AtomicLongFieldUpdater<SampleTimeoutMain> REQUESTED = AtomicLongFieldUpdater.newUpdater(SampleTimeoutMain.class, "requested");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<SampleTimeoutMain> WIP = AtomicIntegerFieldUpdater.newUpdater(SampleTimeoutMain.class, "wip");
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<SampleTimeoutMain, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(SampleTimeoutMain.class, Throwable.class, "error");
        volatile boolean done;
        volatile boolean cancelled;
        volatile long index;
        static final AtomicLongFieldUpdater<SampleTimeoutMain> INDEX = AtomicLongFieldUpdater.newUpdater(SampleTimeoutMain.class, "index");

        @Override
        public final Subscriber<? super T> actual() {
            return this.actual;
        }

        SampleTimeoutMain(Subscriber<? super T> actual, Function<? super T, ? extends Publisher<U>> throttler, Queue<SampleTimeoutOther<T, U>> queue) {
            this.actual = actual;
            this.throttler = throttler;
            this.queue = queue;
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(Scannable.from(this.other));
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.done;
                }
                case CANCELLED: {
                    return this.cancelled;
                }
                case PARENT: {
                    return this.s;
                }
                case ERROR: {
                    return this.error;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
                case BUFFERED: {
                    return this.queue.size();
                }
            }
            return InnerOperator.super.scan(key);
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                Operators.terminate(S, this);
                Operators.terminate(OTHER, this);
            }
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            Publisher<U> p;
            long idx = INDEX.incrementAndGet(this);
            if (!Operators.set(OTHER, this, Operators.emptySubscription())) {
                return;
            }
            try {
                p = Objects.requireNonNull(this.throttler.apply(t), "throttler returned a null publisher");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            SampleTimeoutOther os = new SampleTimeoutOther(this, t, idx);
            if (Operators.replace(OTHER, this, os)) {
                p.subscribe(os);
            }
        }

        void error(Throwable t) {
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.done = true;
                this.drain();
            } else {
                Operators.onErrorDropped(t);
            }
        }

        public void onError(Throwable t) {
            Operators.terminate(OTHER, this);
            this.error(t);
        }

        public void onComplete() {
            Subscription o = this.other;
            if (o instanceof SampleTimeoutOther) {
                SampleTimeoutOther os = (SampleTimeoutOther)o;
                os.cancel();
                os.onComplete();
            }
            this.done = true;
            this.drain();
        }

        void otherNext(SampleTimeoutOther<T, U> other) {
            this.queue.offer(other);
            this.drain();
        }

        void otherError(long idx, Throwable e) {
            if (idx == this.index) {
                Operators.terminate(S, this);
                this.error(e);
            } else {
                Operators.onErrorDropped(e);
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            Subscriber<? super T> a = this.actual;
            Queue<SampleTimeoutOther<T, U>> q = this.queue;
            int missed = 1;
            while (true) {
                boolean empty;
                boolean d = this.done;
                SampleTimeoutOther<T, U> o = q.poll();
                boolean bl = empty = o == null;
                if (this.checkTerminated(d, empty, a, q)) {
                    return;
                }
                if (!empty) {
                    if (o.index != this.index) continue;
                    long r = this.requested;
                    if (r != 0L) {
                        a.onNext(o.value);
                        if (r == Long.MAX_VALUE) continue;
                        REQUESTED.decrementAndGet(this);
                        continue;
                    }
                    this.cancel();
                    q.clear();
                    Throwable e = Exceptions.failWithOverflow("Could not emit value due to lack of requests");
                    Exceptions.addThrowable(ERROR, this, e);
                    e = Exceptions.terminate(ERROR, this);
                    a.onError(e);
                    return;
                }
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, Queue<?> q) {
            if (this.cancelled) {
                q.clear();
                return true;
            }
            if (d) {
                Throwable e = Exceptions.terminate(ERROR, this);
                if (e != null && e != Exceptions.TERMINATED) {
                    this.cancel();
                    q.clear();
                    a.onError(e);
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }
    }
}

