/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxIterable;
import reactor.core.publisher.Operators;

final class FluxStream<T>
extends Flux<T>
implements Fuseable {
    final Stream<? extends T> stream;

    FluxStream(Stream<? extends T> iterable) {
        this.stream = Objects.requireNonNull(iterable, "stream");
    }

    public void subscribe(Subscriber<? super T> s) {
        Iterator it;
        try {
            it = Objects.requireNonNull(this.stream.iterator(), "The stream returned a null Iterator");
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        FluxIterable.subscribe(s, it);
    }
}

