/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.FluxFlatMap;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxSwitchMap<T, R>
extends FluxSource<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final Supplier<? extends Queue<Object>> queueSupplier;
    final int bufferSize;
    static final SwitchMapInner<Object> CANCELLED_INNER = new SwitchMapInner(null, 0, Long.MAX_VALUE);

    FluxSwitchMap(Publisher<? extends T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, Supplier<? extends Queue<Object>> queueSupplier, int bufferSize) {
        super(source);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("BUFFER_SIZE > 0 required but it was " + bufferSize);
        }
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.queueSupplier = Objects.requireNonNull(queueSupplier, "queueSupplier");
        this.bufferSize = bufferSize;
    }

    @Override
    public long getPrefetch() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        if (FluxFlatMap.trySubscribeScalarMap(this.source, s, this.mapper, false)) {
            return;
        }
        this.source.subscribe(new SwitchMapMain<T, R>(s, this.mapper, this.queueSupplier.get(), this.bufferSize));
    }

    static final class SwitchMapInner<R>
    implements InnerConsumer<R>,
    Subscription {
        final SwitchMapMain<?, R> parent;
        final int bufferSize;
        final int limit;
        final long index;
        volatile int once;
        static final AtomicIntegerFieldUpdater<SwitchMapInner> ONCE = AtomicIntegerFieldUpdater.newUpdater(SwitchMapInner.class, "once");
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<SwitchMapInner, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(SwitchMapInner.class, Subscription.class, "s");
        int produced;

        SwitchMapInner(SwitchMapMain<?, R> parent, int bufferSize, long index) {
            this.parent = parent;
            this.bufferSize = bufferSize;
            this.limit = bufferSize - (bufferSize >> 2);
            this.index = index;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.s == Operators.cancelledSubscription();
                }
                case PARENT: {
                    return this.s;
                }
                case ACTUAL: {
                    return this.parent;
                }
                case PREFETCH: {
                    return this.bufferSize;
                }
            }
            return null;
        }

        public void onSubscribe(Subscription s) {
            Subscription a = this.s;
            if (a == Operators.cancelledSubscription()) {
                s.cancel();
            }
            if (a != null) {
                s.cancel();
                Operators.reportSubscriptionSet();
                return;
            }
            if (S.compareAndSet(this, null, s)) {
                s.request((long)this.bufferSize);
                return;
            }
            a = this.s;
            if (a != Operators.cancelledSubscription()) {
                s.cancel();
                Operators.reportSubscriptionSet();
            }
        }

        public void onNext(R t) {
            this.parent.innerNext(this, t);
        }

        public void onError(Throwable t) {
            this.parent.innerError(this, t);
        }

        public void onComplete() {
            this.parent.innerComplete(this);
        }

        void deactivate() {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.parent.deactivate();
            }
        }

        void requestOne() {
            int p = this.produced + 1;
            if (p == this.limit) {
                this.produced = 0;
                this.s.request((long)p);
            } else {
                this.produced = p;
            }
        }

        public void request(long n) {
            long p = (long)this.produced + n;
            if (p >= (long)this.limit) {
                this.produced = 0;
                this.s.request(p);
            } else {
                this.produced = (int)p;
            }
        }

        public void cancel() {
            Subscription a = this.s;
            if (a != Operators.cancelledSubscription() && (a = S.getAndSet(this, Operators.cancelledSubscription())) != null && a != Operators.cancelledSubscription()) {
                a.cancel();
            }
        }
    }

    static final class SwitchMapMain<T, R>
    implements InnerOperator<T, R> {
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final Queue<Object> queue;
        final BiPredicate<Object, Object> queueBiAtomic;
        final int bufferSize;
        final Subscriber<? super R> actual;
        Subscription s;
        volatile boolean done;
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<SwitchMapMain, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(SwitchMapMain.class, Throwable.class, "error");
        volatile boolean cancelled;
        volatile int once;
        static final AtomicIntegerFieldUpdater<SwitchMapMain> ONCE = AtomicIntegerFieldUpdater.newUpdater(SwitchMapMain.class, "once");
        volatile long requested;
        static final AtomicLongFieldUpdater<SwitchMapMain> REQUESTED = AtomicLongFieldUpdater.newUpdater(SwitchMapMain.class, "requested");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<SwitchMapMain> WIP = AtomicIntegerFieldUpdater.newUpdater(SwitchMapMain.class, "wip");
        volatile SwitchMapInner<R> inner;
        static final AtomicReferenceFieldUpdater<SwitchMapMain, SwitchMapInner> INNER = AtomicReferenceFieldUpdater.newUpdater(SwitchMapMain.class, SwitchMapInner.class, "inner");
        volatile long index;
        static final AtomicLongFieldUpdater<SwitchMapMain> INDEX = AtomicLongFieldUpdater.newUpdater(SwitchMapMain.class, "index");
        volatile int active;
        static final AtomicIntegerFieldUpdater<SwitchMapMain> ACTIVE = AtomicIntegerFieldUpdater.newUpdater(SwitchMapMain.class, "active");

        @Override
        public final Subscriber<? super R> actual() {
            return this.actual;
        }

        SwitchMapMain(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, Queue<Object> queue, int bufferSize) {
            this.actual = actual;
            this.mapper = mapper;
            this.queue = queue;
            this.bufferSize = bufferSize;
            this.active = 1;
            this.queueBiAtomic = queue instanceof BiPredicate ? (BiPredicate)((Object)queue) : null;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.cancelled;
                }
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.done;
                }
                case ERROR: {
                    return this.error;
                }
                case PREFETCH: {
                    return this.bufferSize;
                }
                case BUFFERED: {
                    return this.queue.size();
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.inner);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            Publisher<? extends R> p;
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            long idx = INDEX.incrementAndGet(this);
            SwitchMapInner<R> si = this.inner;
            if (si != null) {
                si.deactivate();
                si.cancel();
            }
            try {
                p = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null publisher");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            SwitchMapInner innerSubscriber = new SwitchMapInner(this, this.bufferSize, idx);
            if (INNER.compareAndSet(this, si, innerSubscriber)) {
                ACTIVE.getAndIncrement(this);
                p.subscribe(innerSubscriber);
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            if (Exceptions.addThrowable(ERROR, this, t)) {
                if (ONCE.compareAndSet(this, 0, 1)) {
                    this.deactivate();
                }
                this.cancelInner();
                this.done = true;
                this.drain();
            } else {
                Operators.onErrorDropped(t);
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.deactivate();
            }
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                if (WIP.getAndIncrement(this) == 0) {
                    this.cancelAndCleanup(this.queue);
                }
            }
        }

        void deactivate() {
            ACTIVE.decrementAndGet(this);
        }

        void cancelInner() {
            SwitchMapInner<Object> si = INNER.getAndSet(this, CANCELLED_INNER);
            if (si != null && si != CANCELLED_INNER) {
                si.cancel();
                si.deactivate();
            }
        }

        void cancelAndCleanup(Queue<?> q) {
            this.s.cancel();
            this.cancelInner();
            q.clear();
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            Subscriber<? super R> a = this.actual;
            Queue<Object> q = this.queue;
            int missed = 1;
            do {
                long r = this.requested;
                long e = 0L;
                while (r != e) {
                    Object second;
                    boolean empty;
                    boolean d = this.active == 0;
                    SwitchMapInner si = (SwitchMapInner)q.poll();
                    boolean bl = empty = si == null;
                    if (this.checkTerminated(d, empty, a, q)) {
                        return;
                    }
                    if (empty) break;
                    while ((second = q.poll()) == null) {
                    }
                    if (this.index != si.index) continue;
                    Object v = second;
                    a.onNext(v);
                    si.requestOne();
                    ++e;
                }
                if (r == e && this.checkTerminated(this.active == 0, q.isEmpty(), a, q)) {
                    return;
                }
                if (e == 0L || r == Long.MAX_VALUE) continue;
                REQUESTED.addAndGet(this, -e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, Queue<?> q) {
            if (this.cancelled) {
                this.cancelAndCleanup(q);
                return true;
            }
            if (d) {
                Throwable e = Exceptions.terminate(ERROR, this);
                if (e != null && e != Exceptions.TERMINATED) {
                    this.cancelAndCleanup(q);
                    a.onError(e);
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }

        void innerNext(SwitchMapInner<R> inner, R value) {
            this.queueBiAtomic.test(inner, value);
            this.drain();
        }

        void innerError(SwitchMapInner<R> inner, Throwable e) {
            if (Exceptions.addThrowable(ERROR, this, e)) {
                this.s.cancel();
                if (ONCE.compareAndSet(this, 0, 1)) {
                    this.deactivate();
                }
                inner.deactivate();
                this.drain();
            } else {
                Operators.onErrorDropped(e);
            }
        }

        void innerComplete(SwitchMapInner<R> inner) {
            inner.deactivate();
            this.drain();
        }
    }
}

