/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.UnicastProcessor;

final class FluxWindowOnCancel<T>
extends FluxSource<T, Flux<T>> {
    final Supplier<? extends Queue<T>> processorQueueSupplier;

    FluxWindowOnCancel(Flux<? extends T> source, Supplier<? extends Queue<T>> processorQueueSupplier) {
        super(source);
        this.processorQueueSupplier = Objects.requireNonNull(processorQueueSupplier, "processorQueueSupplier");
    }

    @Override
    public void subscribe(Subscriber<? super Flux<T>> s) {
        this.source.subscribe(new WindowOnCancelSubscriber(s, this.processorQueueSupplier));
    }

    static final class WindowOnCancelSubscriber<T>
    implements Disposable,
    InnerOperator<T, Flux<T>> {
        final Subscriber<? super Flux<T>> actual;
        final Supplier<? extends Queue<T>> processorQueueSupplier;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowOnCancelSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowOnCancelSubscriber.class, "wip");
        volatile int once;
        static final AtomicIntegerFieldUpdater<WindowOnCancelSubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(WindowOnCancelSubscriber.class, "once");
        Subscription s;
        UnicastProcessor<T> window;
        boolean done;

        WindowOnCancelSubscriber(Subscriber<? super Flux<T>> actual, Supplier<? extends Queue<T>> processorQueueSupplier) {
            this.actual = actual;
            this.processorQueueSupplier = processorQueueSupplier;
            this.wip = 1;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            UnicastProcessor<T> w = this.window;
            if (w == null || w.cancelled) {
                WIP.getAndIncrement(this);
                w = new UnicastProcessor<T>(this.processorQueueSupplier.get(), this);
                this.window = w;
                this.actual.onNext(w);
            }
            w.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onError(t);
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onComplete();
            }
            this.actual.onComplete();
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                this.s.request(n);
            }
        }

        public void cancel() {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.dispose();
            }
        }

        @Override
        public void dispose() {
            if (WIP.decrementAndGet(this) == 0) {
                this.s.cancel();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.once == 1 || this.done;
        }

        @Override
        public Subscriber<? super Flux<T>> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case CANCELLED: {
                    return this.once == 1;
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.window);
        }
    }
}

