/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoCollectList<T, C extends Collection<? super T>>
extends MonoSource<T, C>
implements Fuseable {
    final Supplier<C> collectionSupplier;

    MonoCollectList(Flux<? extends T> source, Supplier<C> collectionSupplier) {
        super(source);
        this.collectionSupplier = collectionSupplier;
    }

    @Override
    public void subscribe(Subscriber<? super C> s) {
        Collection collection;
        try {
            collection = (Collection)Objects.requireNonNull(this.collectionSupplier.get(), "The collectionSupplier returned a null collection");
        }
        catch (Throwable ex) {
            Operators.error(s, Operators.onOperatorError(ex));
            return;
        }
        this.source.subscribe(new MonoBufferAllSubscriber(s, collection));
    }

    static final class MonoBufferAllSubscriber<T, C extends Collection<? super T>>
    extends Operators.MonoSubscriber<T, C> {
        C collection;
        Subscription s;

        MonoBufferAllSubscriber(Subscriber<? super C> actual, C collection) {
            super(actual);
            this.collection = collection;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
            }
            return super.scan(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            this.collection.add(t);
        }

        @Override
        public void onError(Throwable t) {
            C c = this.collection;
            if (c == null) {
                return;
            }
            this.collection = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            C c = this.collection;
            if (c == null) {
                return;
            }
            this.collection = null;
            this.complete(c);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

