/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoCompletionStage<T>
extends Mono<T>
implements Fuseable {
    final CompletionStage<? extends T> future;

    MonoCompletionStage(CompletionStage<? extends T> future) {
        this.future = Objects.requireNonNull(future, "future");
    }

    public void subscribe(Subscriber<? super T> s) {
        Operators.MonoSubscriber sds = new Operators.MonoSubscriber(s);
        s.onSubscribe(sds);
        if (sds.isCancelled()) {
            return;
        }
        this.future.whenComplete((v, e) -> {
            if (e != null) {
                s.onError(e);
            } else if (v != null) {
                sds.complete(v);
            } else {
                s.onComplete();
            }
        });
    }
}

