/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

class MonoFilterWhen<T>
extends MonoSource<T, T> {
    final Function<? super T, ? extends Publisher<Boolean>> asyncPredicate;

    MonoFilterWhen(Mono<T> source, Function<? super T, ? extends Publisher<Boolean>> asyncPredicate) {
        super(source);
        this.asyncPredicate = asyncPredicate;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new MonoFilterWhenSubscriber<T>(s, this.asyncPredicate));
    }

    static final class FilterWhenInner
    implements InnerConsumer<Boolean> {
        final MonoFilterWhenSubscriber<?> parent;
        final boolean cancelOnNext;
        boolean done;
        volatile Subscription sub;
        static final AtomicReferenceFieldUpdater<FilterWhenInner, Subscription> SUB = AtomicReferenceFieldUpdater.newUpdater(FilterWhenInner.class, Subscription.class, "sub");

        FilterWhenInner(MonoFilterWhenSubscriber<?> parent, boolean cancelOnNext) {
            this.parent = parent;
            this.cancelOnNext = cancelOnNext;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(SUB, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(Boolean t) {
            if (!this.done) {
                if (this.cancelOnNext) {
                    this.sub.cancel();
                }
                this.done = true;
                this.parent.innerResult(t);
            }
        }

        public void onError(Throwable t) {
            if (!this.done) {
                this.done = true;
                this.parent.innerError(t);
            } else {
                Operators.onErrorDropped(t);
            }
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.parent.innerResult(null);
            }
        }

        void cancel() {
            Operators.terminate(SUB, this);
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.parent;
                }
                case ACTUAL: {
                    return this.sub;
                }
                case CANCELLED: {
                    return this.sub == Operators.cancelledSubscription();
                }
                case TERMINATED: {
                    return this.done;
                }
                case PREFETCH: {
                    return Integer.MAX_VALUE;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.done ? 0 : 1;
                }
            }
            return null;
        }
    }

    static final class MonoFilterWhenSubscriber<T>
    extends Operators.MonoSubscriber<T, T> {
        final Function<? super T, ? extends Publisher<Boolean>> asyncPredicate;
        boolean sourceValued;
        Subscription upstream;
        volatile FilterWhenInner asyncFilter;
        static final AtomicReferenceFieldUpdater<MonoFilterWhenSubscriber, FilterWhenInner> ASYNC_FILTER = AtomicReferenceFieldUpdater.newUpdater(MonoFilterWhenSubscriber.class, FilterWhenInner.class, "asyncFilter");
        static final FilterWhenInner INNER_CANCELLED = new FilterWhenInner(null, false);

        MonoFilterWhenSubscriber(Subscriber<? super T> actual, Function<? super T, ? extends Publisher<Boolean>> asyncPredicate) {
            super(actual);
            this.asyncPredicate = asyncPredicate;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.upstream, s)) {
                this.upstream = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            Publisher<Boolean> p;
            this.sourceValued = true;
            this.setValue(t);
            try {
                p = Objects.requireNonNull(this.asyncPredicate.apply(t), "The asyncPredicate returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                super.onError(ex);
                return;
            }
            if (p instanceof Callable) {
                Boolean u;
                try {
                    u = (Boolean)((Callable)p).call();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    super.onError(ex);
                    return;
                }
                if (u != null && u.booleanValue()) {
                    this.complete(t);
                } else {
                    this.actual.onComplete();
                }
            } else {
                FilterWhenInner inner = new FilterWhenInner(this, !(p instanceof Mono));
                if (ASYNC_FILTER.compareAndSet(this, null, inner)) {
                    p.subscribe((Subscriber)inner);
                }
            }
        }

        @Override
        public void onComplete() {
            if (!this.sourceValued) {
                super.onComplete();
            }
        }

        @Override
        public void cancel() {
            if (this.state != 4) {
                super.cancel();
                this.upstream.cancel();
                this.cancelInner();
            }
        }

        void cancelInner() {
            FilterWhenInner a = this.asyncFilter;
            if (a != INNER_CANCELLED && (a = ASYNC_FILTER.getAndSet(this, INNER_CANCELLED)) != null && a != INNER_CANCELLED) {
                a.cancel();
            }
        }

        void innerResult(Boolean item) {
            if (item != null && item.booleanValue()) {
                this.complete(this.value);
            } else {
                super.onComplete();
            }
        }

        void innerError(Throwable ex) {
            super.onError(ex);
        }

        @Override
        public Object upstream() {
            return this.upstream;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.upstream;
                }
                case TERMINATED: {
                    return this.asyncFilter != null ? this.asyncFilter.scan(Scannable.Attr.TERMINATED) : super.scan(Scannable.Attr.TERMINATED);
                }
            }
            return super.scan(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            FilterWhenInner c = this.asyncFilter;
            return c == null ? Stream.empty() : Stream.of(c);
        }
    }
}

