/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;

public class MonoSource<I, O>
extends Mono<O>
implements Scannable,
Receiver {
    protected final Publisher<? extends I> source;

    public static <I> Mono<I> wrap(Publisher<? extends I> source) {
        if (source instanceof Fuseable) {
            return new FuseableMonoSource<I>(source);
        }
        return new MonoSource(source);
    }

    protected MonoSource(Publisher<? extends I> source) {
        this.source = Objects.requireNonNull(source);
    }

    public void subscribe(Subscriber<? super O> s) {
        this.source.subscribe(s);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append('{').append(" \"operator\" : ").append('\"').append(this.getClass().getSimpleName().replaceAll("Mono", "")).append('\"').append(' ').append('}').toString();
    }

    public final Publisher<? extends I> upstream() {
        return this.source;
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case PARENT: {
                return this.source;
            }
        }
        return null;
    }

    static final class FuseableMonoSource<I>
    extends MonoSource<I, I>
    implements Fuseable {
        FuseableMonoSource(Publisher<? extends I> source) {
            super(source);
        }
    }
}

