/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSubscribeOnValue;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class MonoSubscribeOnValue<T>
extends Mono<T> {
    final T value;
    final Scheduler scheduler;

    MonoSubscribeOnValue(T value, Scheduler scheduler) {
        this.value = value;
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    public void subscribe(Subscriber<? super T> s) {
        T v = this.value;
        if (v == null) {
            FluxSubscribeOnValue.ScheduledEmpty parent = new FluxSubscribeOnValue.ScheduledEmpty(s);
            s.onSubscribe((Subscription)parent);
            Cancellation f = this.scheduler.schedule(parent);
            if (f == Scheduler.REJECTED) {
                if (parent.future != Flux.CANCELLED) {
                    s.onError((Throwable)Operators.onRejectedExecution());
                }
            } else {
                parent.setFuture(f);
            }
        } else {
            s.onSubscribe(new FluxSubscribeOnValue.ScheduledScalar<T>(s, v, this.scheduler));
        }
    }
}

