/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoSupplier<T>
extends Mono<T>
implements Callable<T>,
Fuseable {
    final Supplier<? extends T> supplier;

    MonoSupplier(Supplier<? extends T> callable) {
        this.supplier = Objects.requireNonNull(callable, "callable");
    }

    public void subscribe(Subscriber<? super T> s) {
        T t;
        Operators.MonoSubscriber sds = new Operators.MonoSubscriber(s);
        s.onSubscribe(sds);
        if (sds.isCancelled()) {
            return;
        }
        try {
            t = Objects.requireNonNull(this.supplier.get(), "The supplier source returned null");
        }
        catch (Throwable e) {
            s.onError(Operators.onOperatorError(e));
            return;
        }
        sds.complete(t);
    }

    @Override
    public T block(Duration m) {
        return Objects.requireNonNull(this.supplier.get(), "The supplier source returned null");
    }

    @Override
    public T block() {
        return this.block(Duration.ZERO);
    }

    @Override
    public T call() throws Exception {
        return Objects.requireNonNull(this.supplier.get(), "The supplier source returned null");
    }
}

