/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.FluxFlatMap;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoThenMap<T, R>
extends MonoSource<T, R>
implements Fuseable {
    final Function<? super T, ? extends Mono<? extends R>> mapper;

    MonoThenMap(Mono<? extends T> source, Function<? super T, ? extends Mono<? extends R>> mapper) {
        super(source);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        if (FluxFlatMap.trySubscribeScalarMap(this.source, s, this.mapper, true)) {
            return;
        }
        ThenMapMain<? super T, ? super R> manager = new ThenMapMain<T, R>(s, this.mapper);
        s.onSubscribe(manager);
        this.source.subscribe(manager);
    }

    static final class ThenMapMain<T, R>
    extends Operators.MonoSubscriber<T, R> {
        final Function<? super T, ? extends Mono<? extends R>> mapper;
        final ThenMapInner<R> second;
        boolean done;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<ThenMapMain, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(ThenMapMain.class, Subscription.class, "s");

        ThenMapMain(Subscriber<? super R> subscriber, Function<? super T, ? extends Mono<? extends R>> mapper) {
            super(subscriber);
            this.mapper = mapper;
            this.second = new ThenMapInner(this);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.second);
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case CANCELLED: {
                    return this.s == Operators.cancelledSubscription();
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return super.scan(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            Mono<? extends R> m;
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            this.done = true;
            try {
                m = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Mono");
            }
            catch (Throwable ex) {
                this.actual.onError(Operators.onOperatorError(this.s, ex, t));
                return;
            }
            if (m instanceof Callable) {
                Object v;
                Callable c = (Callable)((Object)m);
                try {
                    v = c.call();
                }
                catch (Throwable ex) {
                    this.actual.onError(Operators.onOperatorError(this.s, ex, t));
                    return;
                }
                if (v == null) {
                    this.actual.onComplete();
                } else {
                    this.complete(v);
                }
                return;
            }
            try {
                m.subscribe(this.second);
            }
            catch (Throwable e) {
                this.actual.onError(Operators.onOperatorError(this, e, t));
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public void cancel() {
            super.cancel();
            Operators.terminate(S, this);
            this.second.cancel();
        }

        void secondError(Throwable ex) {
            this.actual.onError(ex);
        }

        void secondComplete() {
            this.actual.onComplete();
        }

        static final class ThenMapInner<R>
        implements InnerConsumer<R> {
            final ThenMapMain<?, R> parent;
            volatile Subscription s;
            static final AtomicReferenceFieldUpdater<ThenMapInner, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(ThenMapInner.class, Subscription.class, "s");
            boolean done;

            ThenMapInner(ThenMapMain<?, R> parent) {
                this.parent = parent;
            }

            @Override
            public Object scan(Scannable.Attr key) {
                switch (key) {
                    case PARENT: {
                        return this.s;
                    }
                    case ACTUAL: {
                        return this.parent;
                    }
                    case TERMINATED: {
                        return this.done;
                    }
                    case CANCELLED: {
                        return this.s == Operators.cancelledSubscription();
                    }
                }
                return null;
            }

            public void onSubscribe(Subscription s) {
                if (Operators.setOnce(S, this, s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(R t) {
                if (this.done) {
                    Operators.onNextDropped(t);
                    return;
                }
                this.done = true;
                this.parent.complete(t);
            }

            public void onError(Throwable t) {
                if (this.done) {
                    Operators.onErrorDropped(t);
                    return;
                }
                this.done = true;
                this.parent.secondError(t);
            }

            public void onComplete() {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.parent.secondComplete();
            }

            void cancel() {
                Operators.terminate(S, this);
            }
        }
    }
}

