/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoUntilOther<T>
extends Mono<T> {
    final boolean delayError;
    final Mono<T> source;
    Publisher<?>[] others;

    MonoUntilOther(boolean delayError, Mono<T> monoSource, Publisher<?> triggerPublisher) {
        this.delayError = delayError;
        this.source = Objects.requireNonNull(monoSource, "monoSource");
        this.others = new Publisher[]{Objects.requireNonNull(triggerPublisher, "triggerPublisher")};
    }

    private MonoUntilOther(boolean delayError, Mono<T> monoSource, Publisher<?>[] triggerPublishers) {
        this.delayError = delayError;
        this.source = Objects.requireNonNull(monoSource, "monoSource");
        this.others = triggerPublishers;
    }

    MonoUntilOther<T> addTrigger(Publisher<?> trigger) {
        Objects.requireNonNull(trigger, "trigger");
        Publisher<?>[] oldTriggers = this.others;
        Publisher[] newTriggers = new Publisher[oldTriggers.length + 1];
        System.arraycopy(oldTriggers, 0, newTriggers, 0, oldTriggers.length);
        newTriggers[oldTriggers.length] = trigger;
        return new MonoUntilOther<T>(this.delayError, this.source, newTriggers);
    }

    public void subscribe(Subscriber<? super T> s) {
        UntilOtherCoordinator<T> parent = new UntilOtherCoordinator<T>(s, this.delayError, this.others.length + 1);
        s.onSubscribe(parent);
        parent.subscribe(this.source, this.others);
    }

    static final class UntilOtherTrigger<T>
    implements InnerConsumer<T> {
        final UntilOtherCoordinator<?> parent;
        final boolean cancelOnTriggerValue;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<UntilOtherTrigger, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(UntilOtherTrigger.class, Subscription.class, "s");
        boolean done;
        Throwable error;

        UntilOtherTrigger(UntilOtherCoordinator<?> parent, boolean cancelOnTriggerValue) {
            this.parent = parent;
            this.cancelOnTriggerValue = cancelOnTriggerValue;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.s == Operators.cancelledSubscription();
                }
                case PARENT: {
                    return this.s;
                }
                case ACTUAL: {
                    return this.parent;
                }
                case ERROR: {
                    return this.error;
                }
            }
            return null;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(1L);
            } else {
                s.cancel();
            }
        }

        public void onNext(Object t) {
            if (!this.done) {
                this.done = true;
                this.parent.signal();
                if (this.cancelOnTriggerValue) {
                    this.s.cancel();
                }
            }
        }

        public void onError(Throwable t) {
            this.error = t;
            this.parent.signalError(t);
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.parent.signal();
            }
        }

        void cancel() {
            Operators.terminate(S, this);
        }
    }

    static final class UntilOtherSource<T>
    implements Subscriber<T> {
        final UntilOtherCoordinator<T> parent;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<UntilOtherSource, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(UntilOtherSource.class, Subscription.class, "s");
        T value;
        Throwable error;

        public UntilOtherSource(UntilOtherCoordinator<T> parent) {
            this.parent = parent;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            } else {
                s.cancel();
            }
        }

        public void onNext(T t) {
            if (this.value == null) {
                this.value = t;
                this.parent.signal();
            }
        }

        public void onError(Throwable t) {
            this.error = t;
            this.parent.signalError(t);
        }

        public void onComplete() {
            if (this.value == null) {
                this.parent.signal();
            }
        }

        void cancel() {
            Operators.terminate(S, this);
        }
    }

    static final class UntilOtherCoordinator<T>
    extends Operators.MonoSubscriber<T, T> {
        final int n;
        final boolean delayError;
        final UntilOtherSource<T> sourceSubscriber;
        final UntilOtherTrigger[] triggerSubscribers;
        volatile int done;
        static final AtomicIntegerFieldUpdater<UntilOtherCoordinator> DONE = AtomicIntegerFieldUpdater.newUpdater(UntilOtherCoordinator.class, "done");

        UntilOtherCoordinator(Subscriber<? super T> subscriber, boolean delayError, int n) {
            super(subscriber);
            this.n = n;
            this.delayError = delayError;
            this.sourceSubscriber = new UntilOtherSource(this);
            this.triggerSubscribers = new UntilOtherTrigger[n - 1];
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.done;
                }
                case PARENT: {
                    return this.sourceSubscriber;
                }
                case DELAY_ERROR: {
                    return this.delayError;
                }
            }
            return super.scan(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.triggerSubscribers);
        }

        void subscribe(Publisher<T> source, Publisher<?>[] triggers) {
            if (triggers.length != this.triggerSubscribers.length) {
                throw new IllegalArgumentException(this.triggerSubscribers.length + " triggers required");
            }
            source.subscribe(this.sourceSubscriber);
            for (int i = 0; i < this.triggerSubscribers.length; ++i) {
                UntilOtherTrigger triggerSubscriber;
                Publisher<?> p = triggers[i];
                boolean cancelOnTriggerValue = !(p instanceof Mono);
                this.triggerSubscribers[i] = triggerSubscriber = new UntilOtherTrigger(this, cancelOnTriggerValue);
                p.subscribe(triggerSubscriber);
            }
        }

        void signalError(Throwable t) {
            if (this.delayError) {
                this.signal();
            } else if (DONE.getAndSet(this, this.n) != this.n) {
                this.cancel();
                this.actual.onError(t);
            }
        }

        void signal() {
            if (DONE.incrementAndGet(this) != this.n) {
                return;
            }
            Object o = null;
            Throwable error = null;
            Throwable compositeError = null;
            boolean sourceEmpty = false;
            UntilOtherSource<T> ms = this.sourceSubscriber;
            Object v = ms.value;
            if (v != null) {
                o = v;
            } else {
                Throwable e = ms.error;
                if (e != null) {
                    error = e;
                } else {
                    sourceEmpty = true;
                }
            }
            for (int i = 0; i < this.n - 1; ++i) {
                UntilOtherTrigger mt = this.triggerSubscribers[i];
                Throwable e = mt.error;
                if (e == null) continue;
                if (compositeError != null) {
                    compositeError.addSuppressed(e);
                    continue;
                }
                if (error != null) {
                    compositeError = new Throwable("Multiple errors");
                    compositeError.addSuppressed(error);
                    compositeError.addSuppressed(e);
                    continue;
                }
                error = e;
            }
            if (compositeError != null) {
                this.actual.onError(compositeError);
            } else if (error != null) {
                this.actual.onError(error);
            } else if (sourceEmpty) {
                this.actual.onComplete();
            } else {
                this.complete(o);
            }
        }

        @Override
        public void cancel() {
            if (!this.isCancelled()) {
                super.cancel();
                this.sourceSubscriber.cancel();
                for (int i = 0; i < this.triggerSubscribers.length; ++i) {
                    UntilOtherTrigger ts = this.triggerSubscribers[i];
                    if (ts == null) continue;
                    ts.cancel();
                }
            }
        }
    }
}

