/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.publisher.RingBuffer;
import reactor.util.concurrent.WaitStrategy;

abstract class RingBufferProducer {
    static final AtomicReferenceFieldUpdater<RingBufferProducer, RingBuffer.Sequence[]> SEQUENCE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(RingBufferProducer.class, RingBuffer.Sequence[].class, "gatingSequences");
    final Runnable spinObserver;
    final int bufferSize;
    final WaitStrategy waitStrategy;
    final RingBuffer.Sequence cursor = RingBuffer.newSequence(-1L);
    volatile RingBuffer.Sequence[] gatingSequences = new RingBuffer.Sequence[0];

    RingBufferProducer(int bufferSize, WaitStrategy waitStrategy, Runnable spinObserver) {
        this.spinObserver = spinObserver;
        this.bufferSize = bufferSize;
        this.waitStrategy = waitStrategy;
    }

    final long getCursor() {
        return this.cursor.getAsLong();
    }

    final int getBufferSize() {
        return this.bufferSize;
    }

    final void addGatingSequence(RingBuffer.Sequence gatingSequence) {
        RingBuffer.addSequence(this, SEQUENCE_UPDATER, gatingSequence);
    }

    boolean removeGatingSequence(RingBuffer.Sequence sequence) {
        return RingBuffer.removeSequence(this, SEQUENCE_UPDATER, sequence);
    }

    long getMinimumSequence(RingBuffer.Sequence excludeSequence) {
        return RingBuffer.getMinimumSequence(excludeSequence, this.gatingSequences, this.cursor.getAsLong());
    }

    RingBuffer.Reader newBarrier() {
        return new RingBuffer.Reader(this, this.waitStrategy, this.cursor);
    }

    abstract long getHighestPublishedSequence(long var1, long var3);

    abstract long getPending();

    abstract long next();

    abstract long next(int var1);

    abstract void publish(long var1);

    RingBuffer.Sequence[] getGatingSequences() {
        return this.gatingSequences;
    }
}

