/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.io.File;
import java.util.function.Supplier;
import org.mule.maven.client.api.LocalRepositorySupplierFactory;

public class DefaultLocalRepositorySupplierFactory
implements LocalRepositorySupplierFactory {
    private static final String USER_HOME = "user.home";
    private static final String M2_REPO = "/.m2/repository";
    private static String userHome = System.getProperty("user.home");
    private static final String REPOSITORY_FOLDER = "repository";

    public Supplier<File> fixedFolderSupplier(File folder) {
        return () -> folder;
    }

    public Supplier<File> environmentMavenRepositorySupplier() {
        return () -> DefaultLocalRepositorySupplierFactory.getMavenLocalRepository();
    }

    public Supplier<File> composeSuppliers(Supplier<File> ... suppliers) {
        return () -> {
            for (Supplier supplier : suppliers) {
                File file = (File)supplier.get();
                if (file == null) continue;
                return file;
            }
            return null;
        };
    }

    public Supplier<File> artifactFolderRepositorySupplier(File artifact, File mavenLocalRepositoryDirectory) {
        return () -> {
            File possibleApplicationRepository = new File(artifact, REPOSITORY_FOLDER);
            if (artifact.isDirectory() && possibleApplicationRepository.exists()) {
                return possibleApplicationRepository;
            }
            if (artifact.getAbsolutePath().contains(REPOSITORY_FOLDER) && !artifact.getAbsolutePath().contains(mavenLocalRepositoryDirectory.getAbsolutePath())) {
                File possibleRepoFolder = artifact;
                while (!possibleRepoFolder.getParentFile().getName().equals(REPOSITORY_FOLDER)) {
                    possibleRepoFolder = possibleRepoFolder.getParentFile();
                }
                return possibleRepoFolder.getParentFile();
            }
            return null;
        };
    }

    private static File getMavenLocalRepository() {
        File mavenLocalRepositoryLocation;
        String localRepositoryProperty = System.getProperty("localRepository");
        if (localRepositoryProperty == null) {
            localRepositoryProperty = userHome + M2_REPO;
        }
        if (!(mavenLocalRepositoryLocation = new File(localRepositoryProperty)).exists()) {
            throw new IllegalArgumentException("Maven repository location couldn't be found, please check your configuration");
        }
        return mavenLocalRepositoryLocation;
    }
}

