/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.io.File;

public class MavenEnvironmentVariables {
    public static final String MAVEN_CMD_LINE_ARGS = "MAVEN_CMD_LINE_ARGS";
    private static final String M2_HOME = "M2_HOME";
    private static final String MAVEN_HOME = "MAVEN_HOME";
    private static final String MAVEN_HOME_SYSTEM_PROPERTY = "maven.home";
    private static final String USER_HOME = "user.home";
    private static String userHome = System.getProperty("user.home");

    public String getM2HomeEnv() {
        return System.getenv(M2_HOME);
    }

    public String getMavenHomeEnv() {
        return System.getenv(MAVEN_HOME);
    }

    public String getMavenCmdLineArgsEnv() {
        return System.getenv(MAVEN_CMD_LINE_ARGS);
    }

    public String getUserHome() {
        return userHome;
    }

    public File getSettingsFileAsSystemOrEnvProperty(String systemPropertyName) {
        File file;
        String property = System.getProperty(systemPropertyName, null);
        if (property == null) {
            property = System.getenv(systemPropertyName);
        }
        if (property != null && (file = new File(property)).exists()) {
            return file;
        }
        return null;
    }

    public String getMavenHomeProperty() {
        return System.getProperty(MAVEN_HOME_SYSTEM_PROPERTY);
    }
}

