/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.graph.DependencyNode;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.internal.AetherMavenClient;

public class MuleArtifactDependencyVisitor {
    private List<BundleDependency> bundleDependencies = new ArrayList<BundleDependency>();
    private List<DependencyNode> foundPlugins = new ArrayList<DependencyNode>();
    private final Map<DependencyNode, Object> visitedNodes = new IdentityHashMap<DependencyNode, Object>(512);

    public void visit(DependencyNode node) {
        if (!this.setVisited(node)) {
            return;
        }
        if (this.isPlugin(node)) {
            if (this.foundPlugins.contains(node)) {
                return;
            }
            this.foundPlugins.add(node);
        }
        this.addDependency(node);
        this.visitChildren(node);
    }

    private boolean isPlugin(DependencyNode node) {
        return node != null && node.getArtifact() != null && "mule-plugin".equals(node.getArtifact().getClassifier());
    }

    private void visitChildren(DependencyNode node) {
        if (this.isPlugin(node)) {
            for (DependencyNode child : node.getChildren()) {
                if (!this.isPlugin(child)) continue;
                this.visit(child);
            }
        } else {
            for (DependencyNode child : node.getChildren()) {
                this.visit(child);
            }
        }
    }

    private void addDependency(DependencyNode node) {
        if (node.getArtifact() != null) {
            this.bundleDependencies.add(AetherMavenClient.artifactToBundleDependency(node.getArtifact(), node.getDependency().getScope()));
        }
    }

    private boolean setVisited(DependencyNode node) {
        return this.visitedNodes.put(node, Boolean.TRUE) == null;
    }

    public List<BundleDependency> getBundleDependencies() {
        return this.bundleDependencies;
    }
}

