/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.manifest;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ExportedArtifactsCollector {
    private static final String META_INF_PREFIX = "/META-INF";
    private final Set<String> filteredPackages = ImmutableSet.builder().add((Object[])new String[]{"java.", "javax.", "org.mule.runtime.", "com.mulesoft.mule.runtime"}).build();
    private final ExtensionModel extensionModel;
    private final Set<Class<?>> exportedClasses = new LinkedHashSet();
    private final ImmutableSet.Builder<String> exportedResources = ImmutableSet.builder();
    private final ClassLoader extensionClassloader;

    public ExportedArtifactsCollector(ExtensionModel extensionModel) {
        this.extensionModel = extensionModel;
        this.extensionClassloader = MuleExtensionUtils.getClassLoader(extensionModel);
    }

    public Set<String> getExportedResources() {
        this.addMetaInfResource("");
        this.addMetaInfResource("extension-manifest.xml");
        this.collectXmlSupportResources();
        return this.exportedResources.build();
    }

    public Set<String> getExportedPackages() {
        this.collectDefault();
        this.collectManuallyExportedPackages();
        Set<String> exportedPackages = this.exportedClasses.stream().filter(type -> type.getPackage() != null).map(type -> type.getPackage().getName()).collect(Collectors.toSet());
        return this.filterExportedPackages(exportedPackages);
    }

    private void collectXmlSupportResources() {
        XmlDslModel languageModel = this.extensionModel.getXmlDslModel();
        this.addMetaInfResource(languageModel.getXsdFileName());
        this.addMetaInfResource("spring.handlers");
        this.addMetaInfResource("spring.schemas");
        this.exportedResources.addAll((Iterable)this.extensionModel.getResources());
    }

    private void addMetaInfResource(String resource) {
        this.exportedResources.add((Object)("/META-INF/" + resource));
    }

    private Set<String> filterExportedPackages(Set<String> exportedPackages) {
        return exportedPackages.stream().filter(packageName -> this.filteredPackages.stream().noneMatch(packageName::startsWith)).collect(Collectors.toSet());
    }

    private void collectManuallyExportedPackages() {
        this.extensionModel.getTypes().forEach(c -> this.exportedClasses.add(JavaTypeUtils.getType((MetadataType)c)));
    }

    private void collectDefault() {
        new ExtensionWalker(){

            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                ExportedArtifactsCollector.this.exportedClasses.addAll(IntrospectionUtils.collectRelativeClasses(model.getType(), ExportedArtifactsCollector.this.extensionClassloader));
            }

            public void onOperation(HasOperationModels owner, OperationModel model) {
                ExportedArtifactsCollector.this.collectReturnTypes((ComponentModel)model);
                ExportedArtifactsCollector.this.collectExceptionTypes(model);
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                ExportedArtifactsCollector.this.collectReturnTypes((ComponentModel)model);
            }
        }.walk(this.extensionModel);
    }

    private void collectReturnTypes(ComponentModel model) {
        this.exportedClasses.addAll(IntrospectionUtils.collectRelativeClasses(model.getOutput().getType(), this.extensionClassloader));
        this.exportedClasses.addAll(IntrospectionUtils.collectRelativeClasses(model.getOutputAttributes().getType(), this.extensionClassloader));
    }

    private void collectExceptionTypes(OperationModel operationModel) {
        operationModel.getModelProperty(ImplementingMethodModelProperty.class).map(ImplementingMethodModelProperty::getMethod).ifPresent(method -> this.exportedClasses.addAll(Arrays.asList(method.getExceptionTypes())));
    }
}

