/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.policy.PolicyManager;
import org.mule.runtime.core.streaming.CursorProviderFactory;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthManager;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class OAuthOperationMessageProcessor
extends OperationMessageProcessor {
    private static Logger LOGGER = LoggerFactory.getLogger(OAuthOperationMessageProcessor.class);
    private final ExtensionsOAuthManager oauthManager;

    public OAuthOperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, ExtensionManager extensionManager, PolicyManager policyManager, ExtensionsOAuthManager oauthManager) {
        super(extensionModel, operationModel, configurationProvider, target, resolverSet, cursorProviderFactory, extensionManager, policyManager);
        this.oauthManager = oauthManager;
    }

    @Override
    protected Mono<Event> doProcess(Event event, ExecutionContextAdapter<OperationModel> operationContext) {
        Optional<OAuthConnectionProviderWrapper> connectionProvider = operationContext.getConfiguration().flatMap(c -> c.getConnectionProvider()).filter(cp -> cp instanceof OAuthConnectionProviderWrapper).map(c -> (OAuthConnectionProviderWrapper)c);
        if (connectionProvider.isPresent()) {
            return this.executeWithOAuthSupport(event, operationContext, connectionProvider.get());
        }
        return super.doProcess(event, operationContext);
    }

    private Mono<Event> executeWithOAuthSupport(Event event, ExecutionContextAdapter<OperationModel> operationContext, OAuthConnectionProviderWrapper connectionProvider) {
        Mono<Event> result = super.doProcess(event, operationContext);
        try {
            return Mono.just((Object)result.block());
        }
        catch (Exception e) {
            AccessTokenExpiredException expiredException = this.getTokenExpirationException(e);
            if (expiredException != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("AccessToken for resourceOwner '%s' expired while executing operation '%s:%s' using config '%s'. Will attempt to refresh token and retry operation", connectionProvider.getResourceOwnerId(), this.getExtensionModel().getName(), ((OperationModel)operationContext.getComponentModel()).getName(), ((ConfigurationInstance)operationContext.getConfiguration().get()).getName()));
                }
                String ownerConfigName = ((ConfigurationInstance)operationContext.getConfiguration().get()).getName();
                try {
                    this.oauthManager.refreshToken(ownerConfigName, expiredException.getResourceOwnerId(), this.getOAuthConnectionProvider(operationContext));
                }
                catch (Exception refreshException) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("AccessToken for resourceOwner '%s' expired while executing operation '%s:%s' using config '%s'. Refresh token workflow was attempted but failed with the following exception", connectionProvider.getResourceOwnerId(), this.getExtensionModel().getName(), ((OperationModel)operationContext.getComponentModel()).getName(), ((ConfigurationInstance)operationContext.getConfiguration().get()).getName())), (Throwable)refreshException);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Access Token successfully refreshed for resourceOwnerId '%s' on config '%s'", connectionProvider.getResourceOwnerId(), ((ConfigurationInstance)operationContext.getConfiguration().get()).getName()));
                }
            } else {
                throw e;
            }
            result = super.doProcess(event, operationContext);
            return result;
        }
    }

    private AccessTokenExpiredException getTokenExpirationException(Exception e) {
        return e instanceof AccessTokenExpiredException ? (AccessTokenExpiredException)e : (AccessTokenExpiredException)ExceptionUtils.extractCauseOfType((Throwable)e, AccessTokenExpiredException.class).orElse(null);
    }

    private OAuthConnectionProviderWrapper getOAuthConnectionProvider(ExecutionContextAdapter operationContext) {
        ConfigurationInstance config = (ConfigurationInstance)operationContext.getConfiguration().get();
        return (OAuthConnectionProviderWrapper)config.getConnectionProvider().get();
    }
}

