/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.config.bootstrap;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.mule.runtime.core.api.config.bootstrap.BootstrapException;
import org.mule.runtime.core.api.config.bootstrap.BootstrapService;
import org.mule.runtime.core.api.config.bootstrap.BootstrapServiceDiscoverer;
import org.mule.runtime.core.api.config.bootstrap.PropertiesBootstrapService;
import org.mule.runtime.core.api.config.bootstrap.RegistryBootstrapDiscoverer;
import org.mule.runtime.core.internal.config.bootstrap.ClassLoaderRegistryBootstrapDiscoverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesBootstrapServiceDiscoverer
implements BootstrapServiceDiscoverer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ClassLoader classLoader;
    private final RegistryBootstrapDiscoverer registryBootstrapDiscoverer;

    public PropertiesBootstrapServiceDiscoverer(ClassLoader classLoader) {
        this(classLoader, new ClassLoaderRegistryBootstrapDiscoverer(classLoader));
    }

    public PropertiesBootstrapServiceDiscoverer(ClassLoader classLoader, RegistryBootstrapDiscoverer registryBootstrapDiscoverer) {
        this.classLoader = classLoader;
        this.registryBootstrapDiscoverer = registryBootstrapDiscoverer;
    }

    @Override
    public List<BootstrapService> discover() {
        LinkedList<BootstrapService> propertiesServices = new LinkedList<BootstrapService>();
        try {
            List<Properties> discoveredProperties = this.registryBootstrapDiscoverer.discover();
            propertiesServices.addAll(discoveredProperties.stream().map(discoveredProperty -> new PropertiesBootstrapService(this.classLoader, (Properties)discoveredProperty)).collect(Collectors.toList()));
        }
        catch (BootstrapException e) {
            this.logger.error("Unable to discover bootstrap properties", (Throwable)((Object)e));
        }
        return propertiesServices;
    }
}

